/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.websockets.next.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.CurrentContext;
import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.ComputingCacheContextInstances;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import io.quarkus.arc.impl.ContextInstances;
import io.quarkus.arc.impl.LazyValue;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Any;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class WebSocketSessionContext
implements ManagedContext {
    private static final Logger LOG = Logger.getLogger(WebSocketSessionContext.class);
    private final CurrentContext<SessionContextState> currentContext;
    private final LazyValue<Event<Object>> initializedEvent;
    private final LazyValue<Event<Object>> beforeDestroyEvent;
    private final LazyValue<Event<Object>> destroyEvent;

    public WebSocketSessionContext(CurrentContextFactory currentContextFactory) {
        this.currentContext = currentContextFactory.create(SessionScoped.class);
        this.initializedEvent = WebSocketSessionContext.newEvent(new Annotation[]{Initialized.Literal.SESSION, Any.Literal.INSTANCE});
        this.beforeDestroyEvent = WebSocketSessionContext.newEvent(new Annotation[]{BeforeDestroyed.Literal.SESSION, Any.Literal.INSTANCE});
        this.destroyEvent = WebSocketSessionContext.newEvent(new Annotation[]{Destroyed.Literal.SESSION, Any.Literal.INSTANCE});
    }

    public Class<? extends Annotation> getScope() {
        return SessionScoped.class;
    }

    public InjectableContext.ContextState getState() {
        SessionContextState state = this.currentState();
        if (state == null) {
            throw this.notActive();
        }
        return state;
    }

    public InjectableContext.ContextState activate(InjectableContext.ContextState initialState) {
        if (initialState == null) {
            SessionContextState state = this.initializeContextState();
            this.currentContext.set((InjectableContext.ContextState)state);
            return state;
        }
        if (initialState instanceof SessionContextState) {
            this.currentContext.set((InjectableContext.ContextState)((SessionContextState)initialState));
            return initialState;
        }
        throw new IllegalArgumentException("Invalid initial state: " + initialState.getClass().getName());
    }

    public void deactivate() {
        this.currentContext.remove();
    }

    public <T> T get(final Contextual<T> contextual, final CreationalContext<T> creationalContext) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        Objects.requireNonNull(creationalContext, "CreationalContext must not be null");
        final InjectableBean bean = (InjectableBean)contextual;
        if (!SessionScoped.class.getName().equals(bean.getScope().getName())) {
            throw this.invalidScope();
        }
        SessionContextState state = this.currentState();
        if (state == null || !state.isValid()) {
            throw this.notActive();
        }
        return (T)state.contextInstances.computeIfAbsent(bean.getIdentifier(), new Supplier<ContextInstanceHandle<?>>(){

            @Override
            public ContextInstanceHandle<?> get() {
                return new ContextInstanceHandleImpl(bean, contextual.create(creationalContext), creationalContext);
            }
        }).get();
    }

    public <T> T get(Contextual<T> contextual) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        InjectableBean bean = (InjectableBean)contextual;
        if (!SessionScoped.class.getName().equals(bean.getScope().getName())) {
            throw this.invalidScope();
        }
        SessionContextState state = this.currentState();
        if (state == null || !state.isValid()) {
            throw this.notActive();
        }
        ContextInstanceHandle instance = state.contextInstances.getIfPresent(bean.getIdentifier());
        return (T)(instance == null ? null : instance.get());
    }

    public boolean isActive() {
        SessionContextState contextState = this.currentState();
        return contextState == null ? false : contextState.isValid();
    }

    public void destroy() {
        this.destroy(this.currentState());
    }

    public void destroy(Contextual<?> contextual) {
        SessionContextState state = this.currentState();
        if (state == null || !state.isValid()) {
            throw this.notActive();
        }
        InjectableBean bean = (InjectableBean)contextual;
        ContextInstanceHandle instance = state.contextInstances.remove(bean.getIdentifier());
        if (instance != null) {
            instance.destroy();
        }
    }

    public void destroy(InjectableContext.ContextState state) {
        if (state == null) {
            return;
        }
        if (state instanceof SessionContextState) {
            SessionContextState sessionState = (SessionContextState)state;
            if (sessionState.invalidate()) {
                this.fireIfNotNull((Event<Object>)((Event)this.beforeDestroyEvent.get()));
                sessionState.contextInstances.removeEach(ContextInstanceHandle::destroy);
                this.fireIfNotNull((Event<Object>)((Event)this.destroyEvent.get()));
            }
        } else {
            throw new IllegalArgumentException("Invalid state implementation: " + state.getClass().getName());
        }
    }

    SessionContextState initializeContextState() {
        SessionContextState state = new SessionContextState((ContextInstances)new ComputingCacheContextInstances());
        this.fireIfNotNull((Event<Object>)((Event)this.initializedEvent.get()));
        return state;
    }

    private SessionContextState currentState() {
        return (SessionContextState)this.currentContext.get();
    }

    private IllegalArgumentException invalidScope() {
        throw new IllegalArgumentException("The bean does not declare @SessionScoped");
    }

    private ContextNotActiveException notActive() {
        return new ContextNotActiveException("Session context is not active");
    }

    private void fireIfNotNull(Event<Object> event) {
        if (event != null) {
            try {
                event.fire((Object)this.toString());
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurred during delivery of the context lifecycle event for " + this.toString()), (Throwable)e);
            }
        }
    }

    private static LazyValue<Event<Object>> newEvent(final Annotation ... qualifiers) {
        return new LazyValue((Supplier)new Supplier<Event<Object>>(){

            @Override
            public Event<Object> get() {
                ArcContainer container = Arc.container();
                if (container.resolveObserverMethods(Object.class, qualifiers).isEmpty()) {
                    return null;
                }
                return container.beanManager().getEvent().select(qualifiers);
            }
        });
    }

    static class SessionContextState
    implements InjectableContext.ContextState {
        private static final int VALID = 0;
        private static final int INVALID = 1;
        private static final VarHandle IS_VALID;
        private final ContextInstances contextInstances;
        private volatile int isValid;

        SessionContextState(ContextInstances contextInstances) {
            this.contextInstances = contextInstances;
        }

        public Map<InjectableBean<?>, Object> getContextualInstances() {
            return this.contextInstances.getAllPresent().stream().collect(Collectors.toUnmodifiableMap(InstanceHandle::getBean, InstanceHandle::get));
        }

        boolean invalidate() {
            return IS_VALID.compareAndSet(this, 0, 1);
        }

        public boolean isValid() {
            return this.isValid == 0;
        }

        static {
            try {
                IS_VALID = MethodHandles.lookup().findVarHandle(SessionContextState.class, "isValid", Integer.TYPE);
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }
    }
}

