/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.resolver.AddressResolverGroup;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.stream.Collectors;
import ratpack.api.Nullable;
import ratpack.exec.ExecController;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.exec.internal.ExecControllerInternal;
import ratpack.func.Action;
import ratpack.http.client.HttpClient;
import ratpack.http.client.HttpClientSpec;
import ratpack.http.client.HttpResponse;
import ratpack.http.client.Proxy;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.StreamedResponse;
import ratpack.http.client.internal.ChannelPoolStats;
import ratpack.http.client.internal.CleanClosingFixedChannelPool;
import ratpack.http.client.internal.ContentAggregatingRequestAction;
import ratpack.http.client.internal.ContentStreamingRequestAction;
import ratpack.http.client.internal.HttpChannelKey;
import ratpack.http.client.internal.HttpChannelPoolMap;
import ratpack.http.client.internal.HttpClientBuilder;
import ratpack.http.client.internal.HttpClientInternal;
import ratpack.http.client.internal.HttpClientStats;
import ratpack.http.client.internal.InstrumentedChannelPoolHandler;
import ratpack.http.client.internal.InstrumentedFixedChannelPoolHandler;
import ratpack.http.client.internal.InstrumentedSimpleChannelPoolHandler;
import ratpack.http.client.internal.ManagedChannelPoolMap;
import ratpack.http.client.internal.NoopFixedChannelPoolHandler;
import ratpack.http.client.internal.NoopSimpleChannelPoolHandler;
import ratpack.http.client.internal.ProxyInternal;
import ratpack.util.internal.TransportDetector;

public class DefaultHttpClient
implements HttpClientInternal {
    private static final ChannelHealthChecker ALWAYS_UNHEALTHY = channel -> channel.eventLoop().newSucceededFuture((Object)Boolean.FALSE);
    final ByteBufAllocator byteBufAllocator;
    final int poolSize;
    final int poolQueueSize;
    final Duration idleTimeout;
    final int maxContentLength;
    final int responseMaxChunkSize;
    final Duration readTimeout;
    final Duration connectTimeout;
    final Action<? super RequestSpec> requestInterceptor;
    final Action<? super HttpResponse> responseInterceptor;
    final Action<? super Throwable> errorInterceptor;
    final boolean enableMetricsCollection;
    final AddressResolverGroup<?> resolver;
    @Nullable
    final ProxyInternal proxy;
    private final Cache<String, ChannelPoolStats> hostStats = Caffeine.newBuilder().maximumSize(1024L).build();
    private final ManagedChannelPoolMap channelPoolMap;

    public DefaultHttpClient(ByteBufAllocator byteBufAllocator, int poolSize, int poolQueueSize, Duration idleTimeout, int maxContentLength, int responseMaxChunkSize, Duration readTimeout, Duration connectTimeout, Action<? super RequestSpec> requestInterceptor, Action<? super HttpResponse> responseInterceptor, Action<? super Throwable> errorInterceptor, boolean enableMetricsCollection, AddressResolverGroup<?> resolver, @Nullable ProxyInternal proxy) {
        this.byteBufAllocator = byteBufAllocator;
        this.poolSize = poolSize;
        this.poolQueueSize = poolQueueSize;
        this.idleTimeout = idleTimeout;
        this.maxContentLength = maxContentLength;
        this.responseMaxChunkSize = responseMaxChunkSize;
        this.readTimeout = readTimeout;
        this.connectTimeout = connectTimeout;
        this.requestInterceptor = requestInterceptor;
        this.responseInterceptor = responseInterceptor;
        this.errorInterceptor = errorInterceptor;
        this.enableMetricsCollection = enableMetricsCollection;
        this.resolver = resolver;
        this.proxy = proxy;
        this.channelPoolMap = this.isPooling() ? this.getPoolingChannelManager() : this.getSimpleChannelManager();
    }

    private ManagedChannelPoolMap getPoolingChannelManager() {
        HttpChannelPoolMap channelPoolMap = new HttpChannelPoolMap(){

            protected ChannelPool newPool(HttpChannelKey key) {
                Bootstrap bootstrap = DefaultHttpClient.this.createBootstrap(key, true);
                InstrumentedChannelPoolHandler channelPoolHandler = DefaultHttpClient.this.getPoolingHandler(key);
                if (DefaultHttpClient.this.enableMetricsCollection) {
                    DefaultHttpClient.this.hostStats.put((Object)key.host, (Object)channelPoolHandler);
                }
                CleanClosingFixedChannelPool channelPool = new CleanClosingFixedChannelPool(bootstrap, channelPoolHandler, DefaultHttpClient.this.getPoolSize(), DefaultHttpClient.this.getPoolQueueSize());
                ((ExecControllerInternal)key.execController).onClose(() -> {
                    this.remove(key);
                    channelPool.closeCleanly();
                });
                return channelPool;
            }
        };
        return channelPoolMap;
    }

    private ManagedChannelPoolMap getSimpleChannelManager() {
        return new ManagedChannelPoolMap(){

            @Override
            public void close() {
            }

            public ChannelPool get(HttpChannelKey key) {
                Bootstrap bootstrap = DefaultHttpClient.this.createBootstrap(key, true);
                return new SimpleChannelPool(bootstrap, (ChannelPoolHandler)DefaultHttpClient.this.getSimpleHandler(key), ALWAYS_UNHEALTHY);
            }

            public boolean contains(HttpChannelKey key) {
                return false;
            }
        };
    }

    private Bootstrap createBootstrap(HttpChannelKey key, boolean pooling) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress(key.host, key.port).group((EventLoopGroup)key.eventLoop)).resolver(this.resolver).channel(TransportDetector.getSocketChannelImpl())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)key.connectTimeout.toMillis()))).option(ChannelOption.ALLOCATOR, (Object)this.byteBufAllocator)).option(ChannelOption.AUTO_READ, (Object)false)).option(ChannelOption.SO_KEEPALIVE, (Object)pooling);
        return bootstrap;
    }

    private InstrumentedChannelPoolHandler getPoolingHandler(HttpChannelKey key) {
        if (this.enableMetricsCollection) {
            return new InstrumentedFixedChannelPoolHandler(key, this.getPoolSize(), this.getIdleTimeout());
        }
        return new NoopFixedChannelPoolHandler(key, this.getIdleTimeout());
    }

    private InstrumentedChannelPoolHandler getSimpleHandler(HttpChannelKey key) {
        if (this.enableMetricsCollection) {
            return new InstrumentedSimpleChannelPoolHandler(key);
        }
        return new NoopSimpleChannelPoolHandler(key);
    }

    @Override
    public int getPoolSize() {
        return this.poolSize;
    }

    @Override
    public int getPoolQueueSize() {
        return this.poolQueueSize;
    }

    @Override
    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    private boolean isPooling() {
        return this.getPoolSize() > 0;
    }

    @Override
    public ChannelPoolMap<HttpChannelKey, ChannelPool> getChannelPoolMap() {
        return this.channelPoolMap;
    }

    @Override
    public Action<? super RequestSpec> getRequestInterceptor() {
        return this.requestInterceptor;
    }

    @Override
    public Action<? super HttpResponse> getResponseInterceptor() {
        return this.responseInterceptor;
    }

    @Override
    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    @Override
    public int getMaxContentLength() {
        return this.maxContentLength;
    }

    @Override
    public int getMaxResponseChunkSize() {
        return this.responseMaxChunkSize;
    }

    @Override
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public Proxy getProxy() {
        return this.proxy;
    }

    @Override
    public ProxyInternal getProxyInternal() {
        return this.proxy;
    }

    @Override
    public void close() {
        this.channelPoolMap.close();
    }

    @Override
    public HttpClient copyWith(Action<? super HttpClientSpec> action) throws Exception {
        HttpClientBuilder builder = new HttpClientBuilder(this);
        action.execute((Object)builder);
        return builder.build();
    }

    @Override
    public Promise<ReceivedResponse> get(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, action);
    }

    @Override
    public Promise<ReceivedResponse> post(URI uri, Action<? super RequestSpec> action) {
        return this.request(uri, (Action<? super RequestSpec>)action.prepend(RequestSpec::post));
    }

    @Override
    public Promise<ReceivedResponse> request(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return this.intercept(Promise.async(downstream -> new ContentAggregatingRequestAction(uri, this, 0, false, Execution.current(), (Action<? super RequestSpec>)requestConfigurer.append(this.requestInterceptor)).connect(downstream)), this.responseInterceptor, this.errorInterceptor);
    }

    @Override
    public Promise<StreamedResponse> requestStream(URI uri, Action<? super RequestSpec> requestConfigurer) {
        return this.intercept(Promise.async(downstream -> new ContentStreamingRequestAction(uri, this, 0, false, Execution.current(), (Action<? super RequestSpec>)requestConfigurer.append(this.requestInterceptor)).connect(downstream)), this.responseInterceptor, this.errorInterceptor);
    }

    private <T extends HttpResponse> Promise<T> intercept(Promise<T> promise, Action<? super HttpResponse> action, Action<? super Throwable> errorAction) {
        Promise returnPromise = promise;
        if (errorAction != Action.noop()) {
            returnPromise = promise.wiretap(r -> {
                if (r.isError()) {
                    ExecController.require().fork().eventLoop(Execution.current().getEventLoop()).start(e -> errorAction.execute((Object)r.getThrowable()));
                }
            });
        }
        if (action != Action.noop()) {
            returnPromise = returnPromise.next(r -> ExecController.require().fork().eventLoop(Execution.current().getEventLoop()).start(e -> action.execute(r)));
        }
        return returnPromise;
    }

    public HttpClientStats getHttpClientStats() {
        return new HttpClientStats(this.hostStats.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ChannelPoolStats)e.getValue()).getHostStats())));
    }
}

