/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.handler.ssl.SslContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import ratpack.api.Nullable;
import ratpack.http.client.Proxy;
import ratpack.http.client.ProxyCredentials;
import ratpack.http.client.ProxySpec;
import ratpack.http.client.internal.DefaultProxyCredentials;
import ratpack.http.client.internal.ProxyInternal;

public class DefaultProxy
implements ProxyInternal {
    private final Proxy.ProxyProtocol protocol;
    private final String host;
    private final int port;
    private final Collection<String> nonProxyHosts;
    private final ProxyCredentials credentials;
    private final SslContext sslContext;

    public DefaultProxy(Proxy.ProxyProtocol protocol, String host, int port, Collection<String> nonProxyHosts, @Nullable ProxyCredentials credentials, SslContext sslContext) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.nonProxyHosts = nonProxyHosts;
        this.credentials = credentials;
        this.sslContext = sslContext;
    }

    @Override
    public Proxy.ProxyProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Collection<String> getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    @Override
    @Nullable
    public ProxyCredentials getCredentials() {
        return this.credentials;
    }

    @Override
    public boolean shouldProxy(String host) {
        return !this.isIgnoredForHost(host);
    }

    @Override
    @Nullable
    public SslContext getSslContext() {
        return this.sslContext;
    }

    public boolean isIgnoredForHost(String hostname) {
        if (this.nonProxyHosts != null && this.nonProxyHosts.size() > 0) {
            for (String nonProxyHost : this.nonProxyHosts) {
                if (!this.matchNonProxyHost(hostname, nonProxyHost)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchNonProxyHost(String targetHost, String nonProxyHost) {
        if (nonProxyHost.length() > 1) {
            if (nonProxyHost.charAt(0) == '*') {
                return targetHost.regionMatches(true, targetHost.length() - nonProxyHost.length() + 1, nonProxyHost, 1, nonProxyHost.length() - 1);
            }
            if (nonProxyHost.charAt(nonProxyHost.length() - 1) == '*') {
                return targetHost.regionMatches(true, 0, nonProxyHost, 0, nonProxyHost.length() - 1);
            }
        }
        return nonProxyHost.equalsIgnoreCase(targetHost);
    }

    @Override
    public boolean useSsl() {
        return this.protocol == Proxy.ProxyProtocol.HTTPS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultProxy that = (DefaultProxy)o;
        return this.protocol.equals((Object)that.protocol) && this.host.equals(that.host) && this.port == that.port && this.nonProxyHosts.equals(that.nonProxyHosts) && Objects.equals(this.credentials, that.credentials);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.protocol, this.host, this.port, this.nonProxyHosts, this.credentials});
    }

    public static class Builder
    implements ProxySpec {
        private Proxy.ProxyProtocol protocol = Proxy.ProxyProtocol.HTTP;
        private String host;
        private int port;
        private Collection<String> nonProxyHosts = Collections.emptyList();
        private ProxyCredentials credentials;
        private SslContext sslContext;

        public Builder() {
        }

        public Builder(ProxyInternal proxy) {
            this.protocol = proxy.getProtocol();
            this.host = proxy.getHost();
            this.port = proxy.getPort();
            this.nonProxyHosts = proxy.getNonProxyHosts();
            this.credentials = proxy.getCredentials();
            this.sslContext = proxy.getSslContext();
        }

        @Override
        public Builder protocol(Proxy.ProxyProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public Builder host(String host) {
            this.host = host;
            return this;
        }

        @Override
        public Builder port(int port) {
            this.port = port;
            return this;
        }

        @Override
        public Builder nonProxyHosts(Collection<String> nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
            return this;
        }

        @Override
        public Builder credentials(String username, String password) {
            this.credentials = new DefaultProxyCredentials(username, password);
            return this;
        }

        public Builder sslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        ProxyInternal build() {
            return new DefaultProxy(this.protocol, this.host, this.port, this.nonProxyHosts, this.credentials, this.protocol == Proxy.ProxyProtocol.HTTPS ? this.sslContext : null);
        }
    }
}

