/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.api.Nullable;
import ratpack.exec.Downstream;
import ratpack.exec.Promise;
import ratpack.func.Action;
import ratpack.handling.RequestOutcome;
import ratpack.handling.internal.DefaultRequestOutcome;
import ratpack.handling.internal.DoubleTransmissionException;
import ratpack.http.Request;
import ratpack.http.internal.ConnectionIdleTimeout;
import ratpack.http.internal.DefaultSentResponse;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;
import ratpack.server.internal.ChunkedFileResponseBodyWriter;
import ratpack.server.internal.LastHttpContentResponseBodyWriter;
import ratpack.server.internal.RequestBody;
import ratpack.server.internal.ResponseBodyWriter;
import ratpack.server.internal.ResponseTransmitter;
import ratpack.server.internal.StreamingResponseBodyWriter;
import ratpack.server.internal.ZeroCopyFileResponseBodyWriter;

public class DefaultResponseTransmitter
implements ResponseTransmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseTransmitter.class);
    private static final LastHttpContentResponseBodyWriter EMPTY_BODY = new LastHttpContentResponseBodyWriter(LastHttpContent.EMPTY_LAST_CONTENT);
    private static final DefaultHttpHeaders ERROR_RESPONSE_HEADERS = new DefaultHttpHeaders();
    private final AtomicBoolean transmitted;
    private final Channel channel;
    private final Clock clock;
    private final Request ratpackRequest;
    private final HttpHeaders responseHeaders;
    private final RequestBody requestBody;
    private final boolean isSsl;
    private final HttpRequest nettyRequest;
    private List<Action<? super RequestOutcome>> outcomeListeners;
    private Instant stopTime;
    private ResponseBodyWriter responseBodyWriter;
    private boolean done;

    public DefaultResponseTransmitter(AtomicBoolean transmitted, Channel channel, Clock clock, HttpRequest nettyRequest, Request ratpackRequest, HttpHeaders responseHeaders, @Nullable RequestBody requestBody) {
        this.transmitted = transmitted;
        this.channel = channel;
        this.clock = clock;
        this.ratpackRequest = ratpackRequest;
        this.responseHeaders = responseHeaders;
        this.requestBody = requestBody;
        this.nettyRequest = nettyRequest;
        this.isSsl = channel.pipeline().get(SslHandler.class) != null;
    }

    private void preSendResponse(HttpResponseStatus responseStatus, ResponseBodyWriter responseBodyWriter, boolean drainRequestBeforeResponse) {
        if (this.transmitted.compareAndSet(false, true)) {
            this.responseBodyWriter = responseBodyWriter;
            this.stopTime = this.clock.instant();
            if (this.requestBody == null) {
                this.sendResponse(responseStatus, responseBodyWriter, true);
            } else if (drainRequestBeforeResponse) {
                this.requestBody.drain().onError(e -> {
                    LOGGER.warn("An error occurred draining the unread request body. The connection will be closed", e);
                    this.forceCloseWithResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                }).then(outcome -> {
                    switch (outcome) {
                        case TOO_LARGE: {
                            responseBodyWriter.dispose();
                            this.forceCloseWithResponse(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
                            break;
                        }
                        case DISCARDED: {
                            this.addConnectionCloseResponseHeader();
                            this.sendResponse(responseStatus, responseBodyWriter, false);
                            break;
                        }
                        case DRAINED: {
                            this.sendResponse(responseStatus, responseBodyWriter, false);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unhandled drain outcome: " + (Object)outcome);
                        }
                    }
                });
            } else {
                this.sendResponse(responseStatus, responseBodyWriter, true);
            }
        } else {
            responseBodyWriter.dispose();
            if (this.done) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("", (Throwable)new DoubleTransmissionException("Attempt at double transmission after response sent for: " + this.ratpackRequest.getRawUri()));
                }
            } else {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("", (Throwable)new DoubleTransmissionException("Attempt at double transmission while sending response (connection will be closed) for: " + this.ratpackRequest.getRawUri()));
                }
                this.channel.close();
            }
        }
    }

    private void sendResponse(HttpResponseStatus responseStatus, ResponseBodyWriter bodyWriter, boolean drainRequestBeforeResponse) {
        try {
            boolean isImplicitlyChunked;
            boolean keepAlive;
            boolean responseRequestedConnectionClose = this.responseHeaders.contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true);
            boolean requestRequestedConnectionClose = !HttpUtil.isKeepAlive((HttpMessage)this.nettyRequest);
            boolean bl = keepAlive = !requestRequestedConnectionClose && !responseRequestedConnectionClose;
            if (!keepAlive && !responseRequestedConnectionClose) {
                this.addConnectionCloseResponseHeader();
            }
            DefaultHttpResponse headersResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, responseStatus, this.responseHeaders);
            boolean bl2 = isImplicitlyChunked = this.mustHaveBody(responseStatus) && keepAlive && HttpUtil.getContentLength((HttpMessage)headersResponse, (int)-1) == -1 && !HttpUtil.isTransferEncodingChunked((HttpMessage)headersResponse);
            if (isImplicitlyChunked) {
                HttpUtil.setTransferEncodingChunked((HttpMessage)headersResponse, (boolean)true);
            }
            this.sendResponseHeadersAndBody(responseStatus, bodyWriter, keepAlive, (HttpResponse)headersResponse, drainRequestBeforeResponse);
        }
        catch (Exception e) {
            bodyWriter.dispose();
            LOGGER.warn("Error finalizing response", (Throwable)e);
            this.forceCloseWithResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void sendResponseHeadersAndBody(HttpResponseStatus responseStatus, ResponseBodyWriter bodyWriter, boolean keepAlive, HttpResponse headersResponse, boolean drainRequestBeforeResponse) {
        Promise.async(down -> this.channel.writeAndFlush((Object)headersResponse).addListener(arg_0 -> ((Downstream)down).success(arg_0))).then(result -> {
            if (result.isSuccess()) {
                this.sendResponseBody(responseStatus, bodyWriter, keepAlive);
            } else {
                this.closeAfterHeaderSendFailure(responseStatus, bodyWriter, drainRequestBeforeResponse, (Future<? super Void>)result);
            }
        });
    }

    private void closeAfterHeaderSendFailure(HttpResponseStatus responseStatus, ResponseBodyWriter bodyWriter, boolean drainRequestBeforeResponse, Future<? super Void> result) {
        if (this.channel.isOpen()) {
            LOGGER.warn("Error writing response headers", result.cause());
            this.channel.close();
        }
        bodyWriter.dispose();
        if (this.requestBody != null && drainRequestBeforeResponse) {
            this.requestBody.drain().onError(e -> {
                LOGGER.warn("An error occurred draining the unread request body after sending the response. The connection will be closed", e);
                this.channel.close();
                this.notifyListeners(responseStatus);
            }).then(outcome -> {
                switch (outcome) {
                    case TOO_LARGE: 
                    case DISCARDED: {
                        this.channel.close();
                        this.notifyListeners(responseStatus);
                        break;
                    }
                    case DRAINED: {
                        this.notifyListeners(responseStatus);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unhandled drain outcome: " + (Object)outcome);
                    }
                }
            });
        } else {
            this.notifyListeners(responseStatus);
        }
    }

    private void sendResponseBody(HttpResponseStatus responseStatus, ResponseBodyWriter bodyWriter, boolean keepAlive) {
        Promise.async(down -> bodyWriter.write(this.channel).addListener(arg_0 -> ((Downstream)down).success(arg_0))).then(result -> {
            if (this.channel.isOpen()) {
                this.closeChannelAfterSendingBody(keepAlive, (Future<? super Void>)result);
            }
            this.notifyListeners(responseStatus);
        });
    }

    private void closeChannelAfterSendingBody(boolean keepAlive, Future<? super Void> result) {
        if (!result.isSuccess()) {
            LOGGER.warn("Error from response body writer", result.cause());
        }
        if (result.isSuccess() && keepAlive) {
            this.channel.read();
            ConnectionIdleTimeout.of(this.channel).reset();
        } else {
            this.channel.close();
        }
    }

    private void forceCloseWithResponse(HttpResponseStatus status) {
        Promise.async(down -> this.channel.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.EMPTY_BUFFER, (HttpHeaders)ERROR_RESPONSE_HEADERS, (HttpHeaders)EmptyHttpHeaders.INSTANCE)).addListener(future -> down.success((Object)future.isSuccess()))).onError(__ -> {
            this.channel.close();
            this.notifyListeners(status);
        }).then(__ -> {
            this.channel.close();
            this.notifyListeners(status);
        });
    }

    private boolean mustHaveBody(HttpResponseStatus responseStatus) {
        int code = responseStatus.code();
        return (code < 100 || code >= 200) && code != 204 && code != 304;
    }

    @Override
    public void transmit(HttpResponseStatus responseStatus, ByteBuf body) {
        if (body.readableBytes() == 0) {
            body.release();
            this.preSendResponse(responseStatus, EMPTY_BODY, true);
        } else {
            this.preSendResponse(responseStatus, new LastHttpContentResponseBodyWriter((LastHttpContent)new DefaultLastHttpContent(body.touch())), true);
        }
    }

    private boolean isHead() {
        return this.ratpackRequest.getMethod().isHead();
    }

    @Override
    public void transmit(HttpResponseStatus status, Path file) {
        if (this.isHead()) {
            this.preSendResponse(status, EMPTY_BODY, true);
        } else {
            String sizeString = this.responseHeaders.getAsString(HttpHeaderConstants.CONTENT_LENGTH);
            long size = sizeString == null ? 0L : Long.parseLong(sizeString);
            boolean compress = !this.responseHeaders.contains(HttpHeaderConstants.CONTENT_ENCODING, HttpHeaderConstants.IDENTITY, true);
            boolean zeroCopy = !this.isSsl && !compress && file.getFileSystem().equals(FileSystems.getDefault());
            ResponseBodyWriter responseBodyWriter = zeroCopy ? new ZeroCopyFileResponseBodyWriter(file, size) : new ChunkedFileResponseBodyWriter(file);
            this.preSendResponse(status, responseBodyWriter, true);
        }
    }

    @Override
    public void transmit(HttpResponseStatus status, Publisher<? extends ByteBuf> publisher, boolean drainRequestBeforeResponse) {
        this.preSendResponse(status, new StreamingResponseBodyWriter(publisher), drainRequestBeforeResponse);
    }

    private void notifyListeners(HttpResponseStatus responseStatus) {
        this.done = true;
        if (this.outcomeListeners != null) {
            DefaultSentResponse sentResponse = new DefaultSentResponse(new NettyHeadersBackedHeaders(this.responseHeaders), new DefaultStatus(responseStatus));
            DefaultRequestOutcome requestOutcome = new DefaultRequestOutcome(this.ratpackRequest, sentResponse, this.stopTime);
            for (Action<? super RequestOutcome> outcomeListener : this.outcomeListeners) {
                try {
                    outcomeListener.execute((Object)requestOutcome);
                }
                catch (Exception e) {
                    LOGGER.warn("request outcome listener " + outcomeListener + " threw exception", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void onWritabilityChanged() {
        if (this.responseBodyWriter != null && this.channel.isWritable()) {
            this.responseBodyWriter.onWritable();
        }
    }

    @Override
    public void onConnectionClosed() {
        if (this.responseBodyWriter != null) {
            this.responseBodyWriter.onClosed();
        }
    }

    @Override
    public void addOutcomeListener(Action<? super RequestOutcome> action) {
        if (this.outcomeListeners == null) {
            this.outcomeListeners = new ArrayList<Action<? super RequestOutcome>>(1);
        }
        this.outcomeListeners.add(action);
    }

    void addConnectionCloseResponseHeader() {
        this.responseHeaders.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }

    static {
        ERROR_RESPONSE_HEADERS.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        ERROR_RESPONSE_HEADERS.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
    }
}

