/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config.internal.module;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.exec.ExecController;
import ratpack.file.FileSystemBinding;
import ratpack.server.ServerConfig;
import ratpack.server.internal.ServerConfigData;
import ratpack.server.internal.ServerEnvironment;

public class ServerConfigDataDeserializer
extends JsonDeserializer<ServerConfigData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerConfigDataDeserializer.class);
    private final InetAddress address;
    private final int port;
    private final boolean development;
    private final URI publicAddress;
    private final Supplier<FileSystemBinding> baseDirSupplier;

    public ServerConfigDataDeserializer(InetAddress address, int port, boolean development, URI publicAddress, Supplier<FileSystemBinding> baseDirSupplier) {
        this.address = address;
        this.port = port;
        this.development = development;
        this.publicAddress = publicAddress;
        this.baseDirSupplier = baseDirSupplier;
    }

    public ServerConfigData deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = jp.getCodec();
        ObjectNode serverNode = (ObjectNode)jp.readValueAsTree();
        ServerConfigData data = new ServerConfigData(this.baseDirSupplier.get(), this.address, this.port, this.development, this.publicAddress);
        if (serverNode.hasNonNull("execController")) {
            data.setExecController(ServerConfigDataDeserializer.toValue(codec, serverNode.get("execController"), ExecController.class));
        } else if (serverNode.hasNonNull("inheritExecController")) {
            data.setExecController((ExecController)ExecController.current().orElseThrow(() -> new IllegalStateException("inheritExecController = false, but there is no current exec controller")));
        }
        if (serverNode.hasNonNull("port")) {
            data.setPort(this.parsePort(serverNode.get("port")));
        }
        if (serverNode.hasNonNull("address")) {
            data.setAddress(ServerConfigDataDeserializer.toValue(codec, serverNode.get("address"), InetAddress.class));
        }
        if (serverNode.hasNonNull("idleTimeout")) {
            data.setIdleTimeout(ServerConfigDataDeserializer.toValue(codec, serverNode.get("idleTimeout"), Duration.class));
        }
        if (serverNode.hasNonNull("development")) {
            data.setDevelopment(serverNode.get("development").asBoolean(false));
        }
        if (serverNode.hasNonNull("threads")) {
            data.setThreads(serverNode.get("threads").asInt(ServerConfig.DEFAULT_THREADS));
        }
        if (serverNode.hasNonNull("registerShutdownHook")) {
            data.setRegisterShutdownHook(serverNode.get("registerShutdownHook").asBoolean(true));
        }
        if (serverNode.hasNonNull("publicAddress")) {
            data.setPublicAddress(ServerConfigDataDeserializer.toValue(codec, serverNode.get("publicAddress"), URI.class));
        }
        if (serverNode.hasNonNull("maxContentLength")) {
            data.setMaxContentLength(serverNode.get("maxContentLength").asInt(0x100000));
        }
        if (serverNode.hasNonNull("maxChunkSize")) {
            data.setMaxChunkSize(serverNode.get("maxChunkSize").asInt(8192));
        }
        if (serverNode.hasNonNull("maxInitialLineLength")) {
            data.setMaxInitialLineLength(serverNode.get("maxInitialLineLength").asInt(4096));
        }
        if (serverNode.hasNonNull("maxHeaderSize")) {
            data.setMaxHeaderSize(serverNode.get("maxHeaderSize").asInt(8192));
        }
        if (serverNode.hasNonNull("requireClientSslAuth")) {
            data.setRequireClientSslAuth(serverNode.get("requireClientSslAuth").asBoolean(false));
        }
        if (serverNode.hasNonNull("ssl")) {
            data.setSslContext(ServerConfigDataDeserializer.toValue(codec, serverNode.get("ssl"), SslContext.class));
        } else if (serverNode.hasNonNull("jdkSsl")) {
            data.setSslContext((SslContext)this.toJdkSslContext(data, ServerConfigDataDeserializer.toValue(codec, serverNode.get("jdkSsl"), SSLContext.class)));
        }
        if (serverNode.hasNonNull("baseDir")) {
            throw new IllegalStateException("baseDir value cannot be set via config, it must be set directly via ServerConfigBuilder.baseDir()");
        }
        if (serverNode.hasNonNull("connectTimeoutMillis")) {
            this.parseOptionalIntValue("connectTimeoutMillis", serverNode.get("connectTimeoutMillis")).ifPresent(data::setConnectTimeoutMillis);
        }
        if (serverNode.hasNonNull("maxMessagesPerRead")) {
            this.parseOptionalIntValue("maxMessagesPerRead", serverNode.get("maxMessagesPerRead")).ifPresent(data::setMaxMessagesPerRead);
        }
        if (serverNode.hasNonNull("receiveBufferSize")) {
            this.parseOptionalIntValue("receiveBufferSize", serverNode.get("receiveBufferSize")).ifPresent(data::setReceiveBufferSize);
        }
        if (serverNode.hasNonNull("writeSpinCount")) {
            this.parseOptionalIntValue("writeSpinCount", serverNode.get("writeSpinCount")).ifPresent(data::setWriteSpinCount);
        }
        if (serverNode.hasNonNull("connectQueueSize")) {
            this.parseOptionalIntValue("connectQueueSize", serverNode.get("connectQueueSize")).ifPresent(data::setConnectQueueSize);
        }
        if (serverNode.hasNonNull("tcpKeepAlive")) {
            data.setTcpKeepAlive(serverNode.get("tcpKeepAlive").asBoolean(false));
        }
        if (serverNode.hasNonNull("portFile")) {
            data.setPortFile(ServerConfigDataDeserializer.toValue(codec, serverNode.get("portFile"), Path.class));
        }
        return data;
    }

    private JdkSslContext toJdkSslContext(ServerConfigData data, SSLContext jdkSslContext) {
        return new JdkSslContext(jdkSslContext, false, data.isRequireClientSslAuth() ? ClientAuth.REQUIRE : ClientAuth.NONE);
    }

    private int parsePort(JsonNode node) {
        return node.isInt() ? node.asInt() : ServerEnvironment.parsePortValue("config", node.asText()).intValue();
    }

    private static <T> T toValue(ObjectCodec codec, JsonNode node, Class<T> valueType) throws JsonProcessingException {
        Object pojo;
        if (node.isPojo() && valueType.isInstance(pojo = ((POJONode)node).getPojo())) {
            return valueType.cast(pojo);
        }
        return (T)codec.treeToValue((TreeNode)node, valueType);
    }

    public Optional<Integer> parseOptionalIntValue(String description, JsonNode node) {
        try {
            return Optional.of(Integer.parseInt(node.asText()));
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Failed to parse {} value {} to int", (Object)description, (Object)node.asText());
            return Optional.empty();
        }
    }
}

