/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.util.AsciiString;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.security.cert.X509Certificate;
import ratpack.api.Nullable;
import ratpack.exec.Promise;
import ratpack.func.Block;
import ratpack.func.Function;
import ratpack.http.Headers;
import ratpack.http.HttpMethod;
import ratpack.http.MediaType;
import ratpack.http.Request;
import ratpack.http.TypedData;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.http.internal.DefaultHttpMethod;
import ratpack.http.internal.DefaultMediaType;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.RequestIdleTimeout;
import ratpack.registry.MutableRegistry;
import ratpack.registry.NotInRegistryException;
import ratpack.server.ServerConfig;
import ratpack.server.internal.RequestBodyReader;
import ratpack.stream.Streams;
import ratpack.stream.TransformablePublisher;
import ratpack.util.MultiValueMap;
import ratpack.util.internal.ImmutableDelegatingMultiValueMap;

public class DefaultRequest
implements Request {
    private MutableRegistry registry;
    private final Headers headers;
    private final RequestBodyReader bodyReader;
    private final String rawUri;
    private final HttpMethod method;
    private final String protocol;
    private final InetSocketAddress remoteSocket;
    private final InetSocketAddress localSocket;
    private final Instant timestamp;
    private String uri;
    private ImmutableDelegatingMultiValueMap<String, String> queryParams;
    private String query;
    private String path;
    private Set<Cookie> cookies;
    private long maxContentLength;
    private final RequestIdleTimeout idleTimeout;
    private final X509Certificate clientCertificate;

    public DefaultRequest(Instant timestamp, Headers headers, io.netty.handler.codec.http.HttpMethod method, HttpVersion protocol, String rawUri, InetSocketAddress remoteSocket, InetSocketAddress localSocket, ServerConfig serverConfig, @Nullable RequestBodyReader bodyReader, RequestIdleTimeout idleTimeout, @Nullable X509Certificate clientCertificate) {
        this.headers = headers;
        this.bodyReader = bodyReader;
        this.method = DefaultHttpMethod.valueOf(method);
        this.protocol = protocol.toString();
        this.rawUri = rawUri;
        this.remoteSocket = remoteSocket;
        this.localSocket = localSocket;
        this.timestamp = timestamp;
        this.maxContentLength = serverConfig.getMaxContentLength();
        this.idleTimeout = idleTimeout;
        this.clientCertificate = clientCertificate;
        if (bodyReader != null) {
            bodyReader.setMaxContentLength(serverConfig.getMaxContentLength());
        }
    }

    @Override
    public MultiValueMap<String, String> getQueryParams() {
        if (this.queryParams == null) {
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.getRawUri());
            this.queryParams = new ImmutableDelegatingMultiValueMap(queryStringDecoder.parameters());
        }
        return this.queryParams;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setMaxContentLength(long maxContentLength) {
        if (this.bodyReader == null) {
            this.maxContentLength = maxContentLength;
        } else {
            this.bodyReader.setMaxContentLength(maxContentLength);
        }
    }

    @Override
    public long getMaxContentLength() {
        if (this.bodyReader == null) {
            return this.maxContentLength;
        }
        return this.bodyReader.getMaxContentLength();
    }

    @Override
    public Optional<X509Certificate> getClientCertificate() {
        return Optional.ofNullable(this.clientCertificate);
    }

    @Override
    public String getRawUri() {
        return this.rawUri;
    }

    @Override
    public String getUri() {
        if (this.uri == null) {
            if (this.rawUri.startsWith("/")) {
                this.uri = this.rawUri;
            } else {
                URI parsed = URI.create(this.rawUri);
                String path = parsed.getPath();
                if (Strings.isNullOrEmpty((String)path)) {
                    path = "/";
                }
                StringBuilder sb = new StringBuilder();
                sb.append(path);
                if (parsed.getQuery() != null) {
                    sb.append("?").append(parsed.getQuery());
                }
                if (parsed.getFragment() != null) {
                    sb.append("#").append(parsed.getFragment());
                }
                this.uri = sb.toString();
            }
        }
        return this.uri;
    }

    @Override
    public String getQuery() {
        if (this.query == null) {
            String uri = this.getUri();
            int i = uri.indexOf("?");
            this.query = i < 0 || i == uri.length() ? "" : uri.substring(i + 1);
        }
        return this.query;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            String uri = this.getUri();
            String noSlash = uri.substring(1);
            int i = noSlash.indexOf("?");
            this.path = i < 0 ? noSlash : noSlash.substring(0, i);
        }
        return this.path;
    }

    @Override
    public Set<Cookie> getCookies() {
        if (this.cookies == null) {
            String header = this.headers.get((CharSequence)HttpHeaderNames.COOKIE);
            this.cookies = header == null || header.length() == 0 ? Collections.emptySet() : ServerCookieDecoder.STRICT.decode(header);
        }
        return this.cookies;
    }

    @Override
    public String oneCookie(String name) {
        Cookie found = null;
        ArrayList<Cookie> allFound = null;
        for (Cookie cookie : this.getCookies()) {
            if (!cookie.name().equals(name)) continue;
            if (found == null) {
                found = cookie;
                continue;
            }
            if (allFound == null) {
                allFound = new ArrayList<Cookie>(2);
                allFound.add(found);
                continue;
            }
            allFound.add(cookie);
        }
        if (found == null) {
            return null;
        }
        if (allFound != null) {
            StringBuilder s = new StringBuilder("Multiple cookies with name '").append(name).append("': ");
            int i = 0;
            for (Cookie cookie : allFound) {
                s.append(cookie.toString());
                if (++i >= allFound.size()) continue;
                s.append(", ");
            }
            throw new IllegalStateException(s.toString());
        }
        return found.value();
    }

    @Override
    public boolean isAjaxRequest() {
        return "XMLHttpRequest".equalsIgnoreCase(this.headers.get(HttpHeaderConstants.X_REQUESTED_WITH));
    }

    @Override
    public Promise<TypedData> getBody() {
        return this.getBody(RequestBodyReader.DEFAULT_TOO_LARGE_SENTINEL);
    }

    @Override
    public void setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout.setRequestIdleTimeout(idleTimeout);
    }

    @Override
    public Promise<TypedData> getBody(Block onTooLarge) {
        if (this.bodyReader == null) {
            return Promise.value((Object)new ByteBufBackedTypedData(Unpooled.EMPTY_BUFFER, this.getContentType()));
        }
        return this.bodyReader.read(onTooLarge).map(b -> new ByteBufBackedTypedData((ByteBuf)b, this.getContentType()));
    }

    @Override
    public Promise<TypedData> getBody(long maxContentLength) {
        this.setMaxContentLength(maxContentLength);
        return this.getBody(RequestBodyReader.DEFAULT_TOO_LARGE_SENTINEL);
    }

    @Override
    public Promise<TypedData> getBody(long maxContentLength, Block onTooLarge) {
        this.setMaxContentLength(maxContentLength);
        return this.getBody(onTooLarge);
    }

    @Override
    public TransformablePublisher<? extends ByteBuf> getBodyStream() {
        if (this.bodyReader == null) {
            return Streams.empty();
        }
        return this.bodyReader.readStream();
    }

    @Override
    public TransformablePublisher<? extends ByteBuf> getBodyStream(long maxContentLength) {
        this.setMaxContentLength(maxContentLength);
        return this.getBodyStream();
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public MediaType getContentType() {
        return DefaultMediaType.get(this.headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
    }

    @Override
    public boolean isExpectsContinue() {
        return Iterables.any(this.headers.getAll((CharSequence)HttpHeaderNames.EXPECT), arg_0 -> ((AsciiString)HttpHeaderValues.CONTINUE).contentEqualsIgnoreCase(arg_0));
    }

    @Override
    public boolean isChunkedTransfer() {
        return Iterables.any(this.headers.getAll((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), arg_0 -> ((AsciiString)HttpHeaderValues.CHUNKED).contentEqualsIgnoreCase(arg_0));
    }

    @Override
    public long getContentLength() {
        return this.bodyReader == null ? -1L : this.bodyReader.getContentLength();
    }

    @Override
    public HostAndPort getRemoteAddress() {
        return HostAndPort.fromParts((String)this.remoteSocket.getHostString(), (int)this.remoteSocket.getPort());
    }

    @Override
    public HostAndPort getLocalAddress() {
        return HostAndPort.fromParts((String)this.localSocket.getHostString(), (int)this.localSocket.getPort());
    }

    @Override
    public <O> Request addLazy(TypeToken<O> type, Supplier<? extends O> supplier) {
        this.getDelegateRegistry().addLazy(type, supplier);
        return this;
    }

    @Override
    public <O> Request add(TypeToken<O> type, O object) {
        this.getDelegateRegistry().add(type, object);
        return this;
    }

    @Override
    public <O> Request add(Class<O> type, O object) {
        this.getDelegateRegistry().add(type, object);
        return this;
    }

    @Override
    public Request add(Object object) {
        this.getDelegateRegistry().add(object);
        return this;
    }

    @Override
    public <O> Request addLazy(Class<O> type, Supplier<? extends O> supplier) {
        this.getDelegateRegistry().addLazy(type, supplier);
        return this;
    }

    public <T> void remove(TypeToken<T> type) throws NotInRegistryException {
        this.getDelegateRegistry().remove(type);
    }

    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        return this.getDelegateRegistry().maybeGet(type);
    }

    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        return this.getDelegateRegistry().getAll(type);
    }

    public <T, O> Optional<O> first(TypeToken<T> type, Function<? super T, ? extends O> function) throws Exception {
        return this.getDelegateRegistry().first(type, function);
    }

    private MutableRegistry getDelegateRegistry() {
        if (this.registry == null) {
            throw new IllegalStateException("Cannot access registry before it has been set");
        }
        return this.registry;
    }

    public static void setDelegateRegistry(DefaultRequest request, MutableRegistry registry) {
        request.registry = registry;
    }
}

