/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server;

import java.net.URI;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.http.HttpUrlBuilder;
import ratpack.server.RatpackServer;
import ratpack.server.internal.ConstantPublicAddress;
import ratpack.server.internal.InferringPublicAddress;
import ratpack.server.internal.ServerBindPublicAddress;

public interface PublicAddress {
    public static PublicAddress of(URI uri) {
        return new ConstantPublicAddress(uri);
    }

    public static PublicAddress inferred(String defaultScheme) {
        return new InferringPublicAddress(defaultScheme);
    }

    public static PublicAddress bindAddress(RatpackServer server) {
        return new ServerBindPublicAddress(server);
    }

    @Deprecated
    default public URI get(Context ctx) {
        return this.get();
    }

    default public URI get() {
        throw new UnsupportedOperationException("this implementation does not support this method, use get(Context)");
    }

    @Deprecated
    default public HttpUrlBuilder builder(Context ctx) {
        return this.builder();
    }

    default public HttpUrlBuilder builder() {
        return HttpUrlBuilder.base(this.get());
    }

    @Deprecated
    default public URI get(Context ctx, Action<? super HttpUrlBuilder> action) throws Exception {
        return ((HttpUrlBuilder)action.with((Object)this.builder())).build();
    }

    default public URI get(Action<? super HttpUrlBuilder> action) throws Exception {
        return ((HttpUrlBuilder)action.with((Object)this.builder())).build();
    }

    @Deprecated
    default public URI get(Context ctx, String path) {
        return this.builder().path(path).build();
    }

    default public URI get(String path) {
        return this.builder().path(path).build();
    }
}

