/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server;

import java.time.Duration;
import java.util.Optional;
import ratpack.api.Nullable;
import ratpack.func.Action;
import ratpack.impose.Impositions;
import ratpack.registry.Registry;
import ratpack.server.RatpackServerSpec;
import ratpack.server.internal.DefaultRatpackServer;

public interface RatpackServer {
    public static RatpackServer of(Action<? super RatpackServerSpec> definition) throws Exception {
        return new DefaultRatpackServer(definition, Impositions.current());
    }

    public static RatpackServer start(Action<? super RatpackServerSpec> definition) throws Exception {
        RatpackServer server = RatpackServer.of(definition);
        server.start();
        return server;
    }

    public String getScheme();

    public int getBindPort();

    @Nullable
    public String getBindHost();

    public boolean isRunning();

    public void start() throws Exception;

    public void stop() throws Exception;

    public boolean await(Duration var1) throws InterruptedException;

    public RatpackServer reload() throws Exception;

    public Optional<Registry> getRegistry();
}

