/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import ratpack.func.Block;
import ratpack.server.RatpackServer;

public abstract class ServerCapturer {
    private static final ThreadLocal<Deque<Consumer<? super RatpackServer>>> CAPTURER_HOLDER = ThreadLocal.withInitial(ArrayDeque::new);

    private ServerCapturer() {
    }

    public static Releaser captureWith(Consumer<? super RatpackServer> capturer) {
        Deque<Consumer<? super RatpackServer>> capturers = CAPTURER_HOLDER.get();
        capturers.addLast(capturer);
        return () -> capturers.remove(capturer);
    }

    public static RatpackServer capture(Block bootstrap) throws Exception {
        class Capturer
        implements Consumer<RatpackServer> {
            RatpackServer server;

            Capturer() {
            }

            @Override
            public void accept(RatpackServer ratpackServer) {
                this.server = ratpackServer;
            }
        }
        Capturer capturer = new Capturer();
        try (Releaser ignored = ServerCapturer.captureWith(capturer);){
            bootstrap.execute();
        }
        return capturer.server;
    }

    public static void capture(RatpackServer server) throws Exception {
        Consumer<? super RatpackServer> capturer = CAPTURER_HOLDER.get().pollLast();
        if (capturer != null) {
            capturer.accept(server);
        }
    }

    public static interface Releaser
    extends AutoCloseable {
        @Override
        public void close();
    }
}

