/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ratpack.exec.Execution;
import ratpack.exec.UnmanagedThreadException;

public abstract class ExecutionBasedScope<S extends Map<Key<?>, Object>>
implements Scope {
    private final Class<S> storeType;
    private final List<Key<?>> keys = new ArrayList();
    private final String name;

    public ExecutionBasedScope(Class<S> storeType, String name) {
        this.storeType = storeType;
        this.name = name;
    }

    public <T> Provider<T> scope(Key<T> key, Provider<T> unscoped) {
        this.keys.add(key);
        return () -> {
            Map<Key<?>, Object> scopedObjects = this.getScopedObjectMap(key);
            Object current = scopedObjects.get(key);
            if (current == null && !scopedObjects.containsKey(key)) {
                current = unscoped.get();
                if (Scopes.isCircularProxy((Object)current)) {
                    return current;
                }
                scopedObjects.put(key, current);
            }
            return current;
        };
    }

    protected abstract S createStore();

    private Map<Key<?>, Object> getScopedObjectMap(Key<?> key) {
        try {
            Execution execution = Execution.current();
            if (!this.inScope(execution)) {
                throw new OutOfScopeException("Cannot access " + key + " outside of " + this.name);
            }
            return execution.maybeGet(this.storeType).orElseGet(() -> {
                S store = this.createStore();
                execution.add(this.storeType, store);
                return store;
            });
        }
        catch (UnmanagedThreadException e) {
            throw new OutOfScopeException("Cannot access " + key + " outside of " + this.name);
        }
    }

    protected boolean inScope(Execution execution) {
        return true;
    }

    public List<Key<?>> getKeys() {
        return this.keys;
    }
}

