/*
 * Decompiled with CFR 0.152.
 */
package ratpack.guice.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.reactivestreams.Publisher;
import ratpack.api.Blocks;
import ratpack.error.ClientErrorHandler;
import ratpack.error.ServerErrorHandler;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInitializer;
import ratpack.exec.Execution;
import ratpack.exec.Promise;
import ratpack.file.FileSystemBinding;
import ratpack.file.MimeTypes;
import ratpack.form.internal.FormParser;
import ratpack.guice.ExecutionScoped;
import ratpack.guice.RequestScoped;
import ratpack.guice.internal.BlockingInterceptor;
import ratpack.guice.internal.ExecutionScope;
import ratpack.guice.internal.GuiceUtil;
import ratpack.guice.internal.RequestScope;
import ratpack.handling.Redirector;
import ratpack.http.Request;
import ratpack.http.Response;
import ratpack.http.client.HttpClient;
import ratpack.registry.Registry;
import ratpack.render.Renderable;
import ratpack.render.Renderer;
import ratpack.server.PublicAddress;
import ratpack.server.RatpackServer;
import ratpack.server.ServerConfig;
import ratpack.sse.ServerSentEventStreamClient;

public class RatpackBaseRegistryModule
extends AbstractModule {
    private final Registry baseRegistry;

    public RatpackBaseRegistryModule(Registry baseRegistry) {
        this.baseRegistry = baseRegistry;
    }

    protected void configure() {
        ExecutionScope executionScope = new ExecutionScope();
        this.bindScope(ExecutionScoped.class, executionScope);
        RequestScope requestScope = new RequestScope();
        this.bindScope(RequestScoped.class, requestScope);
        this.bind(ExecutionScope.class).toInstance((Object)executionScope);
        this.bind(RequestScope.class).toInstance((Object)requestScope);
        this.bind(ExecutionPrimingInitializer.class);
        ImmutableList simpleTypes = ImmutableList.of(ServerConfig.class, ByteBufAllocator.class, ExecController.class, MimeTypes.class, PublicAddress.class, Redirector.class, ClientErrorHandler.class, ServerErrorHandler.class, RatpackServer.class);
        ImmutableList genericTypes = ImmutableList.of((Object)new TypeToken<Renderer<Path>>(){}, (Object)new TypeToken<Renderer<Promise>>(){}, (Object)new TypeToken<Renderer<Publisher>>(){}, (Object)new TypeToken<Renderer<Renderable>>(){}, (Object)new TypeToken<Renderer<CharSequence>>(){});
        ImmutableList setTypes = ImmutableList.of(FormParser.class);
        ImmutableList optionalTypes = ImmutableList.of(FileSystemBinding.class);
        simpleTypes.stream().forEach(t -> this.simpleBind((Class)t));
        genericTypes.stream().forEach(t -> this.genericBind((TypeToken)t));
        setTypes.stream().forEach(t -> this.setBind((Class)t));
        optionalTypes.stream().forEach(t -> this.optionalBind((Class)t));
        BlockingInterceptor interceptor = new BlockingInterceptor();
        this.bindInterceptor(Matchers.annotatedWith(Blocks.class), (Matcher)new NotGroovyMethodMatcher(), new MethodInterceptor[]{interceptor});
        this.bindInterceptor(Matchers.any(), Matchers.annotatedWith(Blocks.class), new MethodInterceptor[]{interceptor});
    }

    private <T> void simpleBind(Class<T> type) {
        this.bind(type).toProvider(() -> this.baseRegistry.get(type));
    }

    private <T> void genericBind(TypeToken<T> typeToken) {
        TypeLiteral typeLiteral = TypeLiteral.get((Type)typeToken.getType());
        this.bind(typeLiteral).toProvider(() -> this.baseRegistry.get(typeToken));
    }

    private <T> void setBind(Class<T> type) {
        Multibinder setBinder = Multibinder.newSetBinder((Binder)this.binder(), type);
        this.baseRegistry.getAll(type).forEach(instance -> setBinder.addBinding().toInstance(instance));
    }

    private <T> void optionalBind(Class<T> type) {
        Optional optional = this.baseRegistry.maybeGet(type);
        if (optional.isPresent()) {
            this.bind(type).toProvider(() -> this.baseRegistry.get(type));
        }
    }

    @Provides
    HttpClient httpClient(ByteBufAllocator byteBufAllocator, ServerConfig serverConfig) {
        return HttpClient.httpClient((ByteBufAllocator)byteBufAllocator, (int)serverConfig.getMaxContentLength());
    }

    @Provides
    ServerSentEventStreamClient sseClient(ByteBufAllocator byteBufAllocator) {
        return ServerSentEventStreamClient.sseStreamClient((ByteBufAllocator)byteBufAllocator);
    }

    @Provides
    @ExecutionScoped
    Execution execution() {
        return Execution.current();
    }

    @Provides
    @RequestScoped
    Request request(Execution execution) throws Throwable {
        return (Request)execution.maybeGet(Request.class).orElseThrow(() -> {
            throw new RuntimeException("Cannot inject Request in execution scope as execution has no request object - this execution is not processing a request");
        });
    }

    @Provides
    @RequestScoped
    Response response(Execution execution) throws Throwable {
        return (Response)execution.maybeGet(Response.class).orElseThrow(() -> {
            throw new RuntimeException("Cannot inject Response in execution scope as execution has no response object - this execution is not processing a request");
        });
    }

    private static class NotGroovyMethodMatcher
    extends AbstractMatcher<Method> {
        private NotGroovyMethodMatcher() {
        }

        public boolean matches(Method method) {
            return !method.isSynthetic();
        }
    }

    @Singleton
    static class ExecutionPrimingInitializer
    implements ExecInitializer {
        private final List<Key<?>> executionScope;
        private final List<Key<?>> requestScope;
        private final Injector injector;

        @Inject
        public ExecutionPrimingInitializer(ExecutionScope executionScope, RequestScope requestScope, Injector injector) {
            this.executionScope = ImmutableList.copyOf((Iterable)Iterables.filter(executionScope.getKeys(), input -> !input.getTypeLiteral().getRawType().equals(Execution.class)));
            this.requestScope = ImmutableList.copyOf((Iterable)Iterables.filter(requestScope.getKeys(), input -> !input.getTypeLiteral().getRawType().equals(Request.class) && !input.getTypeLiteral().getRawType().equals(Response.class)));
            this.injector = injector;
        }

        public void init(Execution execution) {
            for (Key<?> key : this.executionScope) {
                this.doAdd(execution, key);
            }
            for (Key<?> key : this.requestScope) {
                this.doAdd(execution, key);
            }
        }

        public <T> void doAdd(Execution execution, Key<T> key) {
            execution.addLazy(GuiceUtil.toTypeToken(key.getTypeLiteral()), () -> ((Provider)this.injector.getProvider(key)).get());
        }
    }
}

