/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.completable;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.functions.ObjectHelper;
import io.reactivex.rxjava3.internal.operators.completable.CompletableMergeDelayErrorArray;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableMergeDelayErrorIterable
extends Completable {
    final Iterable<? extends CompletableSource> sources;

    public CompletableMergeDelayErrorIterable(Iterable<? extends CompletableSource> sources) {
        this.sources = sources;
    }

    @Override
    public void subscribeActual(CompletableObserver observer) {
        Iterator<? extends CompletableSource> iterator;
        CompositeDisposable set = new CompositeDisposable();
        observer.onSubscribe(set);
        try {
            iterator = ObjectHelper.requireNonNull(this.sources.iterator(), "The source iterator returned is null");
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            observer.onError(e);
            return;
        }
        AtomicInteger wip = new AtomicInteger(1);
        AtomicThrowable error = new AtomicThrowable();
        set.add(new CompletableMergeDelayErrorArray.TryTerminateAndReportDisposable(error));
        while (true) {
            CompletableSource c;
            boolean b;
            if (set.isDisposed()) {
                return;
            }
            try {
                b = iterator.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                error.addThrowable(e);
                break;
            }
            if (!b) break;
            if (set.isDisposed()) {
                return;
            }
            try {
                c = ObjectHelper.requireNonNull(iterator.next(), "The iterator returned a null CompletableSource");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                error.addThrowable(e);
                break;
            }
            if (set.isDisposed()) {
                return;
            }
            wip.getAndIncrement();
            c.subscribe(new CompletableMergeDelayErrorArray.MergeInnerCompletableObserver(observer, set, error, wip));
        }
        if (wip.decrementAndGet() == 0) {
            error.tryTerminateConsumer(observer);
        }
    }
}

