/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.local;

import io.netty.buffer.ByteBuf;
import io.rsocket.DuplexConnection;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

final class LocalDuplexConnection
implements DuplexConnection {
    private final Flux<ByteBuf> in;
    private final MonoProcessor<Void> onClose;
    private final Subscriber<ByteBuf> out;

    LocalDuplexConnection(Flux<ByteBuf> in, Subscriber<ByteBuf> out, MonoProcessor<Void> onClose) {
        this.in = Objects.requireNonNull(in, "in must not be null");
        this.out = Objects.requireNonNull(out, "out must not be null");
        this.onClose = Objects.requireNonNull(onClose, "onClose must not be null");
    }

    public void dispose() {
        this.out.onComplete();
        this.onClose.onComplete();
    }

    public boolean isDisposed() {
        return this.onClose.isDisposed();
    }

    public Mono<Void> onClose() {
        return this.onClose;
    }

    public Flux<ByteBuf> receive() {
        return this.in;
    }

    public Mono<Void> send(Publisher<ByteBuf> frames) {
        Objects.requireNonNull(frames, "frames must not be null");
        return Flux.from(frames).doOnNext(arg_0 -> this.out.onNext(arg_0)).then();
    }

    public Mono<Void> sendOne(ByteBuf frame) {
        Objects.requireNonNull(frame, "frame must not be null");
        this.out.onNext((Object)frame);
        return Mono.empty();
    }
}

