/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.autoinstall.logback;

import io.sentry.autoinstall.AbstractIntegrationInstaller;
import io.sentry.autoinstall.AutoInstallState;
import io.sentry.semver.Version;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackInstallStrategy
extends AbstractIntegrationInstaller {
    @NotNull
    private static final String LOGBACK_GROUP = "ch.qos.logback";
    @NotNull
    private static final String LOGBACK_ID = "logback-classic";
    @NotNull
    public static final String SENTRY_LOGBACK_ID = "sentry-logback";

    public LogbackInstallStrategy() {
        this(LoggerFactory.getLogger(LogbackInstallStrategy.class));
    }

    public LogbackInstallStrategy(@NotNull Logger logger) {
        super(logger);
    }

    @Override
    @Nullable
    protected Artifact findThirdPartyDependency(@NotNull List<Artifact> resolvedArtifacts) {
        return resolvedArtifacts.stream().filter(dep -> dep.getGroupId().equals(LOGBACK_GROUP) && dep.getArtifactId().equals(LOGBACK_ID)).findFirst().orElse(null);
    }

    @Override
    protected boolean shouldInstallModule(@NotNull AutoInstallState autoInstallState) {
        return autoInstallState.isInstallLogback();
    }

    @Override
    @Nullable
    protected Version minSupportedThirdPartyVersion() {
        return Version.create(1, 0, 0);
    }

    @Override
    @NotNull
    protected Version minSupportedSentryVersion() {
        return Version.create(6, 25, 2);
    }

    @Override
    @NotNull
    protected String sentryModuleId() {
        return SENTRY_LOGBACK_ID;
    }
}

