/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.constant;

public enum PoolType {
    HIKARI("com.zaxxer.hikari.HikariDataSource"),
    DRUID("com.alibaba.druid.pool.DruidDataSource"),
    DBCP2("org.apache.commons.dbcp2.BasicDataSource"),
    DBCP2_TOMCAT("org.apache.tomcat.dbcp.dbcp2.BasicDataSource"),
    UNKNOWN("");

    private final String className;

    public static PoolType find(String className) {
        for (PoolType each : PoolType.values()) {
            if (!className.equals(each.className)) continue;
            return each;
        }
        return UNKNOWN;
    }

    private PoolType(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }
}

