/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.executor.sql.execute.result;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Multimap;
import io.shardingsphere.core.constant.AggregationType;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationDistinctSelectItem;
import io.shardingsphere.core.parsing.parser.context.selectitem.AggregationSelectItem;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class AggregationDistinctQueryMetaData {
    private final Collection<AggregationDistinctColumnMetaData> columnMetaDataList = new LinkedList<AggregationDistinctColumnMetaData>();

    public AggregationDistinctQueryMetaData(Collection<AggregationDistinctSelectItem> aggregationDistinctSelectItems, Multimap<String, Integer> columnLabelAndIndexMap) {
        for (AggregationDistinctSelectItem each : aggregationDistinctSelectItems) {
            this.columnMetaDataList.add(this.getAggregationDistinctColumnMetaData(each, (Integer)new ArrayList(columnLabelAndIndexMap.get((Object)each.getColumnLabel())).get(0), columnLabelAndIndexMap));
        }
    }

    private AggregationDistinctColumnMetaData getAggregationDistinctColumnMetaData(AggregationDistinctSelectItem selectItem, int aggregationDistinctColumnIndex, Multimap<String, Integer> columnLabelAndIndexMap) {
        List<AggregationSelectItem> derivedSelectItems = selectItem.getDerivedAggregationSelectItems();
        if (derivedSelectItems.isEmpty()) {
            return new AggregationDistinctColumnMetaData(aggregationDistinctColumnIndex, selectItem.getColumnLabel(), selectItem.getType());
        }
        int countDerivedIndex = columnLabelAndIndexMap.size() + 1;
        int sumDerivedIndex = countDerivedIndex + 1;
        this.reviseColumnLabelAndIndexMap(columnLabelAndIndexMap, selectItem, countDerivedIndex, sumDerivedIndex);
        return new AggregationDistinctColumnMetaData(aggregationDistinctColumnIndex, selectItem.getColumnLabel(), selectItem.getType(), countDerivedIndex, sumDerivedIndex);
    }

    private void reviseColumnLabelAndIndexMap(Multimap<String, Integer> columnLabelAndIndexMap, AggregationDistinctSelectItem selectItem, int countDerivedIndex, int sumDerivedIndex) {
        columnLabelAndIndexMap.put((Object)selectItem.getDerivedAggregationSelectItems().get(0).getColumnLabel(), (Object)countDerivedIndex);
        columnLabelAndIndexMap.put((Object)selectItem.getDerivedAggregationSelectItems().get(1).getColumnLabel(), (Object)sumDerivedIndex);
    }

    public Collection<Integer> getAggregationDistinctColumnIndexes() {
        return Collections2.transform(this.columnMetaDataList, (Function)new Function<AggregationDistinctColumnMetaData, Integer>(){

            public Integer apply(AggregationDistinctColumnMetaData input) {
                return input.columnIndex;
            }
        });
    }

    public Collection<String> getAggregationDistinctColumnLabels() {
        return Collections2.transform(this.columnMetaDataList, (Function)new Function<AggregationDistinctColumnMetaData, String>(){

            public String apply(AggregationDistinctColumnMetaData input) {
                return input.columnLabel;
            }
        });
    }

    public AggregationType getAggregationType(final int distinctColumnIndex) {
        return ((AggregationDistinctColumnMetaData)Collections2.filter(this.columnMetaDataList, (Predicate)new Predicate<AggregationDistinctColumnMetaData>(){

            public boolean apply(AggregationDistinctColumnMetaData input) {
                return distinctColumnIndex == input.columnIndex;
            }
        }).iterator().next()).aggregationType;
    }

    public Collection<Integer> getDerivedCountColumnIndexes() {
        LinkedList<Integer> result = new LinkedList<Integer>();
        for (AggregationDistinctColumnMetaData each : this.columnMetaDataList) {
            if (-1 == each.derivedCountIndex) continue;
            result.add(each.derivedCountIndex);
        }
        return result;
    }

    public Collection<Integer> getDerivedSumColumnIndexes() {
        LinkedList<Integer> result = new LinkedList<Integer>();
        for (AggregationDistinctColumnMetaData each : this.columnMetaDataList) {
            if (-1 == each.derivedSumIndex) continue;
            result.add(each.derivedSumIndex);
        }
        return result;
    }

    public int getAggregationDistinctColumnIndex(final String aggregationDistinctColumnLabel) {
        return ((AggregationDistinctColumnMetaData)Collections2.filter(this.columnMetaDataList, (Predicate)new Predicate<AggregationDistinctColumnMetaData>(){

            public boolean apply(AggregationDistinctColumnMetaData input) {
                return aggregationDistinctColumnLabel.equals(input.columnLabel);
            }
        }).iterator().next()).columnIndex;
    }

    public int getAggregationDistinctColumnIndex(final int derivedSumIndex) {
        return ((AggregationDistinctColumnMetaData)Collections2.filter(this.columnMetaDataList, (Predicate)new Predicate<AggregationDistinctColumnMetaData>(){

            public boolean apply(AggregationDistinctColumnMetaData input) {
                return derivedSumIndex == input.derivedSumIndex;
            }
        }).iterator().next()).columnIndex;
    }

    public String getAggregationDistinctColumnLabel(final int aggregationDistinctColumnIndex) {
        return ((AggregationDistinctColumnMetaData)Collections2.filter(this.columnMetaDataList, (Predicate)new Predicate<AggregationDistinctColumnMetaData>(){

            public boolean apply(AggregationDistinctColumnMetaData input) {
                return aggregationDistinctColumnIndex == input.columnIndex;
            }
        }).iterator().next()).columnLabel;
    }

    private final class AggregationDistinctColumnMetaData {
        private final int columnIndex;
        private final String columnLabel;
        private final AggregationType aggregationType;
        private final int derivedCountIndex;
        private final int derivedSumIndex;

        private AggregationDistinctColumnMetaData(int columnIndex, String columnLabel, AggregationType aggregationType) {
            this(columnIndex, columnLabel, aggregationType, -1, -1);
        }

        @ConstructorProperties(value={"columnIndex", "columnLabel", "aggregationType", "derivedCountIndex", "derivedSumIndex"})
        public AggregationDistinctColumnMetaData(int columnIndex, String columnLabel, AggregationType aggregationType, int derivedCountIndex, int derivedSumIndex) {
            this.columnIndex = columnIndex;
            this.columnLabel = columnLabel;
            this.aggregationType = aggregationType;
            this.derivedCountIndex = derivedCountIndex;
            this.derivedSumIndex = derivedSumIndex;
        }
    }
}

