/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.merger.dql.orderby;

import com.google.common.base.Preconditions;
import io.shardingsphere.core.merger.QueryResult;
import io.shardingsphere.core.merger.dql.orderby.CompareUtil;
import io.shardingsphere.core.parsing.parser.context.orderby.OrderItem;
import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OrderByValue
implements Comparable<OrderByValue> {
    private final QueryResult queryResult;
    private final List<OrderItem> orderByItems;
    private List<Comparable<?>> orderValues;

    public boolean next() throws SQLException {
        boolean result = this.queryResult.next();
        this.orderValues = result ? this.getOrderValues() : Collections.emptyList();
        return result;
    }

    private List<Comparable<?>> getOrderValues() throws SQLException {
        ArrayList result = new ArrayList(this.orderByItems.size());
        for (OrderItem each : this.orderByItems) {
            Object value = this.queryResult.getValue(each.getIndex(), Object.class);
            Preconditions.checkState((null == value || value instanceof Comparable ? 1 : 0) != 0, (Object)"Order by value must implements Comparable");
            result.add((Comparable)value);
        }
        return result;
    }

    @Override
    public int compareTo(OrderByValue o) {
        for (int i = 0; i < this.orderByItems.size(); ++i) {
            OrderItem thisOrderBy = this.orderByItems.get(i);
            int result = CompareUtil.compareTo(this.orderValues.get(i), o.orderValues.get(i), thisOrderBy.getOrderDirection(), thisOrderBy.getNullOrderDirection());
            if (0 == result) continue;
            return result;
        }
        return 0;
    }

    @ConstructorProperties(value={"queryResult", "orderByItems"})
    public OrderByValue(QueryResult queryResult, List<OrderItem> orderByItems) {
        this.queryResult = queryResult;
        this.orderByItems = orderByItems;
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }
}

