/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.antlr.extractor.impl.ddl.table;

import com.google.common.base.Optional;
import io.shardingsphere.core.parsing.antlr.extractor.OptionalSQLSegmentExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.impl.TableNameExtractor;
import io.shardingsphere.core.parsing.antlr.extractor.util.ExtractorUtils;
import io.shardingsphere.core.parsing.antlr.extractor.util.RuleName;
import io.shardingsphere.core.parsing.antlr.sql.segment.definition.table.RenameTableSegment;
import io.shardingsphere.core.parsing.antlr.sql.segment.table.TableSegment;
import org.antlr.v4.runtime.ParserRuleContext;

public final class RenameTableExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<RenameTableSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> renameTableNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.RENAME_TABLE);
        if (!renameTableNode.isPresent()) {
            return Optional.absent();
        }
        Optional<TableSegment> tableSegment = new TableNameExtractor().extract((ParserRuleContext)renameTableNode.get());
        if (tableSegment.isPresent()) {
            return Optional.of((Object)new RenameTableSegment(((TableSegment)tableSegment.get()).getName()));
        }
        return Optional.absent();
    }
}

