/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.parsing.cache;

import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public final class ParsingResultCache {
    private static final ParsingResultCache INSTANCE = new ParsingResultCache();
    private final Map<String, SoftReference<SQLStatement>> cache = new HashMap<String, SoftReference<SQLStatement>>(65535, 1.0f);

    public static ParsingResultCache getInstance() {
        return INSTANCE;
    }

    public void put(String sql, SQLStatement sqlStatement) {
        this.cache.put(sql, new SoftReference<SQLStatement>(sqlStatement));
    }

    public SQLStatement getSQLStatement(String sql) {
        SoftReference<SQLStatement> result = this.cache.get(sql);
        return null == result ? null : result.get();
    }

    public synchronized void clear() {
        this.cache.clear();
    }
}

