/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.core.rewrite;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import io.shardingsphere.core.optimizer.condition.ShardingConditions;
import io.shardingsphere.core.parsing.lexer.token.DefaultKeyword;
import io.shardingsphere.core.parsing.parser.context.limit.Limit;
import io.shardingsphere.core.parsing.parser.context.orderby.OrderItem;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.parsing.parser.sql.dml.insert.InsertStatement;
import io.shardingsphere.core.parsing.parser.sql.dql.select.SelectStatement;
import io.shardingsphere.core.parsing.parser.token.AggregationDistinctToken;
import io.shardingsphere.core.parsing.parser.token.IndexToken;
import io.shardingsphere.core.parsing.parser.token.InsertColumnToken;
import io.shardingsphere.core.parsing.parser.token.InsertValuesToken;
import io.shardingsphere.core.parsing.parser.token.ItemsToken;
import io.shardingsphere.core.parsing.parser.token.OffsetToken;
import io.shardingsphere.core.parsing.parser.token.OrderByToken;
import io.shardingsphere.core.parsing.parser.token.RemoveToken;
import io.shardingsphere.core.parsing.parser.token.RowCountToken;
import io.shardingsphere.core.parsing.parser.token.SQLToken;
import io.shardingsphere.core.parsing.parser.token.SchemaToken;
import io.shardingsphere.core.parsing.parser.token.TableToken;
import io.shardingsphere.core.rewrite.SQLBuilder;
import io.shardingsphere.core.rewrite.placeholder.AggregationDistinctPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.IndexPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.InsertValuesPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.SchemaPlaceholder;
import io.shardingsphere.core.rewrite.placeholder.TablePlaceholder;
import io.shardingsphere.core.routing.SQLUnit;
import io.shardingsphere.core.routing.type.RoutingTable;
import io.shardingsphere.core.routing.type.TableUnit;
import io.shardingsphere.core.rule.BindingTableRule;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.core.util.SQLUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SQLRewriteEngine {
    private final ShardingRule shardingRule;
    private final String originalSQL;
    private final DatabaseType databaseType;
    private final SQLStatement sqlStatement;
    private final List<SQLToken> sqlTokens;
    private final ShardingConditions shardingConditions;
    private final List<Object> parameters;

    public SQLRewriteEngine(ShardingRule shardingRule, String originalSQL, DatabaseType databaseType, SQLStatement sqlStatement, ShardingConditions shardingConditions, List<Object> parameters) {
        this.shardingRule = shardingRule;
        this.originalSQL = originalSQL;
        this.databaseType = databaseType;
        this.sqlStatement = sqlStatement;
        this.sqlTokens = sqlStatement.getSQLTokens();
        this.shardingConditions = shardingConditions;
        this.parameters = parameters;
    }

    public SQLBuilder rewrite(boolean isSingleRouting) {
        SQLBuilder result = new SQLBuilder(this.parameters);
        if (this.sqlTokens.isEmpty()) {
            return this.appendOriginalLiterals(result);
        }
        this.appendInitialLiterals(!isSingleRouting, result);
        this.appendTokensAndPlaceholders(!isSingleRouting, result);
        return result;
    }

    private SQLBuilder appendOriginalLiterals(SQLBuilder sqlBuilder) {
        sqlBuilder.appendLiterals(this.originalSQL);
        return sqlBuilder;
    }

    private void appendInitialLiterals(boolean isRewrite, SQLBuilder sqlBuilder) {
        if (isRewrite && this.isContainsAggregationDistinctToken()) {
            this.appendAggregationDistinctLiteral(sqlBuilder);
        } else {
            sqlBuilder.appendLiterals(this.originalSQL.substring(0, this.sqlTokens.get(0).getBeginPosition()));
        }
    }

    private boolean isContainsAggregationDistinctToken() {
        return Iterators.tryFind(this.sqlTokens.iterator(), (Predicate)new Predicate<SQLToken>(){

            public boolean apply(SQLToken input) {
                return input instanceof AggregationDistinctToken;
            }
        }).isPresent();
    }

    private void appendAggregationDistinctLiteral(SQLBuilder sqlBuilder) {
        int firstSelectItemStartPosition = ((SelectStatement)this.sqlStatement).getFirstSelectItemStartPosition();
        sqlBuilder.appendLiterals(this.originalSQL.substring(0, firstSelectItemStartPosition));
        sqlBuilder.appendLiterals("DISTINCT ");
        sqlBuilder.appendLiterals(this.originalSQL.substring(firstSelectItemStartPosition, this.sqlTokens.get(0).getBeginPosition()));
    }

    private void appendTokensAndPlaceholders(boolean isRewrite, SQLBuilder sqlBuilder) {
        int count = 0;
        for (SQLToken each : this.sqlTokens) {
            if (each instanceof TableToken) {
                this.appendTablePlaceholder(sqlBuilder, (TableToken)each, count);
            } else if (each instanceof SchemaToken) {
                this.appendSchemaPlaceholder(sqlBuilder, (SchemaToken)each, count);
            } else if (each instanceof IndexToken) {
                this.appendIndexPlaceholder(sqlBuilder, (IndexToken)each, count);
            } else if (each instanceof ItemsToken) {
                this.appendItemsToken(sqlBuilder, (ItemsToken)each, count, isRewrite);
            } else if (each instanceof InsertValuesToken) {
                this.appendInsertValuesToken(sqlBuilder, (InsertValuesToken)each, count);
            } else if (each instanceof RowCountToken) {
                this.appendLimitRowCount(sqlBuilder, (RowCountToken)each, count, isRewrite);
            } else if (each instanceof OffsetToken) {
                this.appendLimitOffsetToken(sqlBuilder, (OffsetToken)each, count, isRewrite);
            } else if (each instanceof OrderByToken) {
                this.appendOrderByToken(sqlBuilder, count, isRewrite);
            } else if (each instanceof InsertColumnToken) {
                this.appendSymbolToken(sqlBuilder, (InsertColumnToken)each, count);
            } else if (each instanceof AggregationDistinctToken) {
                this.appendAggregationDistinctPlaceholder(sqlBuilder, (AggregationDistinctToken)each, count, isRewrite);
            } else if (each instanceof RemoveToken) {
                this.appendRest(sqlBuilder, count, ((RemoveToken)each).getEndPosition());
            }
            ++count;
        }
    }

    private void appendTablePlaceholder(SQLBuilder sqlBuilder, TableToken tableToken, int count) {
        sqlBuilder.appendPlaceholder(new TablePlaceholder(tableToken.getTableName().toLowerCase(), tableToken.getOriginalLiterals()));
        int beginPosition = tableToken.getBeginPosition() + tableToken.getSkippedSchemaNameLength() + tableToken.getOriginalLiterals().length();
        this.appendRest(sqlBuilder, count, beginPosition);
    }

    private void appendSchemaPlaceholder(SQLBuilder sqlBuilder, SchemaToken schemaToken, int count) {
        sqlBuilder.appendPlaceholder(new SchemaPlaceholder(schemaToken.getSchemaName().toLowerCase(), schemaToken.getTableName().toLowerCase()));
        int beginPosition = schemaToken.getBeginPosition() + schemaToken.getOriginalLiterals().length();
        this.appendRest(sqlBuilder, count, beginPosition);
    }

    private void appendIndexPlaceholder(SQLBuilder sqlBuilder, IndexToken indexToken, int count) {
        String indexName = indexToken.getIndexName().toLowerCase();
        String logicTableName = indexToken.getTableName().toLowerCase();
        if (Strings.isNullOrEmpty((String)logicTableName)) {
            logicTableName = this.shardingRule.getLogicTableName(indexName);
        }
        sqlBuilder.appendPlaceholder(new IndexPlaceholder(indexName, logicTableName));
        int beginPosition = indexToken.getBeginPosition() + indexToken.getOriginalLiterals().length();
        this.appendRest(sqlBuilder, count, beginPosition);
    }

    private void appendItemsToken(SQLBuilder sqlBuilder, ItemsToken itemsToken, int count, boolean isRewrite) {
        boolean isRewriteItem = isRewrite || this.sqlStatement instanceof InsertStatement;
        for (int i = 0; i < itemsToken.getItems().size() && isRewriteItem; ++i) {
            if (itemsToken.isFirstOfItemsSpecial() && 0 == i) {
                sqlBuilder.appendLiterals(SQLUtil.getOriginalValue(itemsToken.getItems().get(i), this.databaseType));
                continue;
            }
            sqlBuilder.appendLiterals(", ");
            sqlBuilder.appendLiterals(SQLUtil.getOriginalValue(itemsToken.getItems().get(i), this.databaseType));
        }
        this.appendRest(sqlBuilder, count, itemsToken.getBeginPosition());
    }

    private void appendInsertValuesToken(SQLBuilder sqlBuilder, InsertValuesToken insertValuesToken, int count) {
        sqlBuilder.appendPlaceholder(new InsertValuesPlaceholder(insertValuesToken.getTableName().toLowerCase(), this.shardingConditions));
        this.appendRest(sqlBuilder, count, ((InsertStatement)this.sqlStatement).getInsertValuesListLastPosition());
    }

    private void appendLimitRowCount(SQLBuilder sqlBuilder, RowCountToken rowCountToken, int count, boolean isRewrite) {
        SelectStatement selectStatement = (SelectStatement)this.sqlStatement;
        Limit limit = selectStatement.getLimit();
        if (!isRewrite) {
            sqlBuilder.appendLiterals(String.valueOf(rowCountToken.getRowCount()));
        } else if (!(selectStatement.getGroupByItems().isEmpty() && selectStatement.getAggregationSelectItems().isEmpty() || selectStatement.isSameGroupByAndOrderByItems())) {
            sqlBuilder.appendLiterals(String.valueOf(Integer.MAX_VALUE));
        } else {
            sqlBuilder.appendLiterals(String.valueOf(limit.isNeedRewriteRowCount(this.databaseType) ? rowCountToken.getRowCount() + limit.getOffsetValue() : rowCountToken.getRowCount()));
        }
        int beginPosition = rowCountToken.getBeginPosition() + String.valueOf(rowCountToken.getRowCount()).length();
        this.appendRest(sqlBuilder, count, beginPosition);
    }

    private void appendLimitOffsetToken(SQLBuilder sqlBuilder, OffsetToken offsetToken, int count, boolean isRewrite) {
        sqlBuilder.appendLiterals(isRewrite ? "0" : String.valueOf(offsetToken.getOffset()));
        int beginPosition = offsetToken.getBeginPosition() + String.valueOf(offsetToken.getOffset()).length();
        this.appendRest(sqlBuilder, count, beginPosition);
    }

    private void appendOrderByToken(SQLBuilder sqlBuilder, int count, boolean isRewrite) {
        SelectStatement selectStatement = (SelectStatement)this.sqlStatement;
        if (isRewrite) {
            StringBuilder orderByLiterals = new StringBuilder();
            orderByLiterals.append(" ").append(DefaultKeyword.ORDER).append(" ").append(DefaultKeyword.BY).append(" ");
            int i = 0;
            for (OrderItem each : selectStatement.getOrderByItems()) {
                String columnLabel;
                String string = columnLabel = Strings.isNullOrEmpty((String)each.getColumnLabel()) ? String.valueOf(each.getIndex()) : SQLUtil.getOriginalValue(each.getColumnLabel(), this.databaseType);
                if (0 == i) {
                    orderByLiterals.append(columnLabel).append(" ").append(each.getOrderDirection().name());
                } else {
                    orderByLiterals.append(",").append(columnLabel).append(" ").append(each.getOrderDirection().name());
                }
                ++i;
            }
            orderByLiterals.append(" ");
            sqlBuilder.appendLiterals(orderByLiterals.toString());
        }
        int beginPosition = selectStatement.getGroupByLastPosition();
        this.appendRest(sqlBuilder, count, beginPosition);
    }

    private void appendSymbolToken(SQLBuilder sqlBuilder, InsertColumnToken insertColumnToken, int count) {
        sqlBuilder.appendLiterals(insertColumnToken.getColumnName());
        this.appendRest(sqlBuilder, count, insertColumnToken.getBeginPosition());
    }

    private void appendAggregationDistinctPlaceholder(SQLBuilder sqlBuilder, AggregationDistinctToken distinctToken, int count, boolean isRewrite) {
        if (!isRewrite) {
            sqlBuilder.appendLiterals(distinctToken.getOriginalLiterals());
        } else {
            sqlBuilder.appendPlaceholder(new AggregationDistinctPlaceholder(distinctToken.getColumnName().toLowerCase(), null, distinctToken.getAlias()));
        }
        this.appendRest(sqlBuilder, count, distinctToken.getBeginPosition() + distinctToken.getOriginalLiterals().length());
    }

    private void appendRest(SQLBuilder sqlBuilder, int count, int beginPosition) {
        int endPosition = this.sqlTokens.size() - 1 == count ? this.originalSQL.length() : this.sqlTokens.get(count + 1).getBeginPosition();
        sqlBuilder.appendLiterals(this.originalSQL.substring(beginPosition, endPosition));
    }

    public SQLUnit generateSQL(TableUnit tableUnit, SQLBuilder sqlBuilder, ShardingDataSourceMetaData shardingDataSourceMetaData) {
        return sqlBuilder.toSQL(tableUnit, this.getTableTokens(tableUnit), this.shardingRule, shardingDataSourceMetaData);
    }

    private Map<String, String> getTableTokens(TableUnit tableUnit) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (RoutingTable each : tableUnit.getRoutingTables()) {
            String logicTableName = each.getLogicTableName().toLowerCase();
            result.put(logicTableName, each.getActualTableName());
            Optional<BindingTableRule> bindingTableRule = this.shardingRule.findBindingTableRule(logicTableName);
            if (!bindingTableRule.isPresent()) continue;
            result.putAll(this.getBindingTableTokens(tableUnit.getDataSourceName(), each, (BindingTableRule)bindingTableRule.get()));
        }
        return result;
    }

    private Map<String, String> getBindingTableTokens(String dataSourceName, RoutingTable routingTable, BindingTableRule bindingTableRule) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String each : this.sqlStatement.getTables().getTableNames()) {
            String tableName = each.toLowerCase();
            if (tableName.equals(routingTable.getLogicTableName().toLowerCase()) || !bindingTableRule.hasLogicTable(tableName)) continue;
            result.put(tableName, bindingTableRule.getBindingActualTable(dataSourceName, tableName, routingTable.getActualTableName()));
        }
        return result;
    }
}

