/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.model.utils;

import io.sundr.SundrException;
import io.sundr.model.ClassRef;
import io.sundr.model.Method;
import io.sundr.model.Property;
import io.sundr.utils.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Parsers {
    public static List<ClassRef> parseImports(String content) {
        return Arrays.stream(content.trim().split("(\\r\\n)|(\\n)")).filter(l -> l.matches("^\\s*import .*;\\s*$")).map(l -> l.replaceFirst("\\s*import", "")).map(l -> l.replaceAll("\\s*;\\s*", "")).map(String::trim).map(ClassRef::forName).collect(Collectors.toList());
    }

    public static String parseMethodBody(String content, Method method) {
        try {
            return Parsers.parseMethodBody(content, Pattern.compile(Parsers.createMethodSignatureRegex(method)));
        }
        catch (Exception e) {
            throw new SundrException("Could not match method:" + method.getName() + " with arugments:" + method.getArguments().stream().map(p -> p.withErasure().render()).collect(Collectors.joining(",", "(", ")")), (Throwable)e);
        }
    }

    public static String parseMethodBody(String content, String name, List<Property> arguments) {
        try {
            return Parsers.parseMethodBody(content, Pattern.compile(Parsers.createMethodSignatureRegex(name, arguments)));
        }
        catch (IllegalStateException e) {
            throw new SundrException("Could not match method:" + name + " with arugments:" + arguments.stream().map(p -> p.withErasure().render()).collect(Collectors.joining(",", "(", ")")), (Throwable)e);
        }
    }

    public static String parseMethodBody(String content, Pattern pattern) {
        Matcher m = pattern.matcher(content);
        if (m.find()) {
            int start = m.end() - 1;
            boolean op = false;
            int counter = 0;
            int bodyStart = 0;
            int bodyEnd = 0;
            for (int i = start; !(i >= content.length() || op && counter == 0); ++i) {
                char c = content.charAt(i);
                if (c == '{') {
                    ++counter;
                    if (op) continue;
                    op = true;
                    bodyStart = i + 1;
                    continue;
                }
                if (c != '}') continue;
                --counter;
                bodyEnd = i - 1;
            }
            return content.substring(bodyStart, bodyEnd - 1).trim();
        }
        throw new IllegalStateException("No match for method.");
    }

    public static String createMethodSignatureRegex(Method method) {
        String nameOrType = Strings.isNotNullOrEmpty((String)method.getName()) ? method.getName() : method.getReturnType().getName();
        return Parsers.createMethodSignatureRegex(nameOrType, method.getArguments());
    }

    public static String createMethodSignatureRegex(String name, List<Property> arguments) {
        StringBuilder sb = new StringBuilder();
        sb.append(Pattern.quote(name));
        sb.append("\\s*");
        sb.append(Pattern.quote("("));
        sb.append("\\s*");
        sb.append(arguments.stream().map(a -> Pattern.quote(a.getTypeRef().getName()) + "(<.*>)?\\s*\\.*\\s*\\w+").collect(Collectors.joining("\\s*,\\s*")));
        sb.append("\\s*");
        sb.append(Pattern.quote(")"));
        sb.append("\\s*");
        sb.append(Pattern.quote("{"));
        return sb.toString();
    }
}

