/*
 * Decompiled with CFR 0.152.
 */
package io.trino.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.trino.client.Column;
import io.trino.client.QueryData;
import io.trino.client.QueryError;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementStats;
import io.trino.client.Warning;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

@Immutable
public class QueryResults
implements QueryStatusInfo {
    private final String id;
    private final URI infoUri;
    private final URI partialCancelUri;
    private final URI nextUri;
    private final List<Column> columns;
    private final QueryData data;
    private final StatementStats stats;
    private final QueryError error;
    private final List<Warning> warnings;
    private final String updateType;
    private final Long updateCount;

    @JsonCreator
    public QueryResults(@JsonProperty(value="id") String id, @JsonProperty(value="infoUri") URI infoUri, @JsonProperty(value="partialCancelUri") URI partialCancelUri, @JsonProperty(value="nextUri") URI nextUri, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="data") QueryData data, @JsonProperty(value="stats") StatementStats stats, @JsonProperty(value="error") QueryError error, @JsonProperty(value="warnings") List<Warning> warnings, @JsonProperty(value="updateType") String updateType, @JsonProperty(value="updateCount") Long updateCount) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.infoUri = Objects.requireNonNull(infoUri, "infoUri is null");
        this.partialCancelUri = partialCancelUri;
        this.nextUri = nextUri;
        this.columns = columns != null ? ImmutableList.copyOf(columns) : null;
        this.data = data;
        Preconditions.checkArgument((!QueryResults.hasData(data) || columns != null ? 1 : 0) != 0, (Object)"data present without columns");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.error = error;
        this.warnings = ImmutableList.copyOf((Collection)((Collection)MoreObjects.firstNonNull(warnings, (Object)ImmutableList.of())));
        this.updateType = updateType;
        this.updateCount = updateCount;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public URI getInfoUri() {
        return this.infoUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public URI getPartialCancelUri() {
        return this.partialCancelUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public URI getNextUri() {
        return this.nextUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonIgnore
    public QueryData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public QueryData getRawData() {
        return this.data;
    }

    @Override
    @JsonProperty
    public StatementStats getStats() {
        return this.stats;
    }

    @Override
    @Nullable
    @JsonProperty
    public QueryError getError() {
        return this.error;
    }

    @Override
    @JsonProperty
    public List<Warning> getWarnings() {
        return this.warnings;
    }

    @Override
    @Nullable
    @JsonProperty
    public String getUpdateType() {
        return this.updateType;
    }

    @Override
    @Nullable
    @JsonProperty
    public Long getUpdateCount() {
        return this.updateCount;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("infoUri", (Object)this.infoUri).add("partialCancelUri", (Object)this.partialCancelUri).add("nextUri", (Object)this.nextUri).add("columns", this.columns).add("hasData", QueryResults.hasData(this.data)).add("stats", (Object)this.stats).add("error", (Object)this.error).add("updateType", (Object)this.updateType).add("updateCount", (Object)this.updateCount).toString();
    }

    private static boolean hasData(QueryData data) {
        return data != null && !data.isNull();
    }
}

