/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.cache;

import io.undertow.server.handlers.cache.ConcurrentDirectDeque;
import io.undertow.util.SecureHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class LRUCache<K, V> {
    private static final int SAMPLE_INTERVAL = 5;
    private final int maxEntries;
    private final SecureHashMap<K, CacheEntry<K, V>> cache = new SecureHashMap(16);
    private final ConcurrentDirectDeque<CacheEntry<K, V>> accessQueue = ConcurrentDirectDeque.newInstance();

    public LRUCache(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void add(K key, V newValue) {
        CacheEntry<K, V> value = this.cache.get(key);
        if (value == null) {
            CacheEntry oldest;
            value = new CacheEntry(key, newValue, this);
            CacheEntry<K, V> result = this.cache.putIfAbsent(key, value);
            if (result != null) {
                value = result;
                value.setValue(newValue);
            }
            this.bumpAccess(value);
            if (this.cache.size() > this.maxEntries && (oldest = (CacheEntry)this.accessQueue.poll()) != value) {
                this.remove(oldest.key());
            }
        }
    }

    public V get(K key) {
        CacheEntry<K, V> cacheEntry = this.cache.get(key);
        if (cacheEntry == null) {
            return null;
        }
        if (cacheEntry.hit() % 5 == 0) {
            this.bumpAccess(cacheEntry);
        }
        return cacheEntry.getValue();
    }

    private void bumpAccess(CacheEntry<K, V> cacheEntry) {
        Object prevToken = cacheEntry.claimToken();
        if (prevToken != Boolean.FALSE) {
            if (prevToken != null) {
                this.accessQueue.removeToken(prevToken);
            }
            Object token = null;
            try {
                token = this.accessQueue.offerLastAndReturnToken(cacheEntry);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (!cacheEntry.setToken(token) && token != null) {
                this.accessQueue.removeToken(token);
            }
        }
    }

    public void remove(K key) {
        Object old;
        CacheEntry<K, V> remove = this.cache.remove(key);
        if (remove != null && (old = remove.clearToken()) != null) {
            this.accessQueue.removeToken(old);
        }
    }

    public static final class CacheEntry<K, V> {
        private static final Object CLAIM_TOKEN = new Object();
        private static final AtomicIntegerFieldUpdater<CacheEntry> hitsUpdater = AtomicIntegerFieldUpdater.newUpdater(CacheEntry.class, "hits");
        private static final AtomicReferenceFieldUpdater<CacheEntry, Object> tokenUpdator = AtomicReferenceFieldUpdater.newUpdater(CacheEntry.class, Object.class, "accessToken");
        private final K key;
        private volatile V value;
        private final LRUCache<K, V> cache;
        private volatile int hits = 1;
        private volatile Object accessToken;

        private CacheEntry(K key, V value, LRUCache cache) {
            this.key = key;
            this.value = value;
            this.cache = cache;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }

        public int hit() {
            int i;
            do {
                i = this.hits;
            } while (!hitsUpdater.weakCompareAndSet(this, i++, i));
            return i;
        }

        public K key() {
            return this.key;
        }

        Object claimToken() {
            Object current;
            do {
                if ((current = this.accessToken) != CLAIM_TOKEN) continue;
                return Boolean.FALSE;
            } while (!tokenUpdator.compareAndSet(this, current, CLAIM_TOKEN));
            return current;
        }

        boolean setToken(Object token) {
            return tokenUpdator.compareAndSet(this, CLAIM_TOKEN, token);
        }

        Object clearToken() {
            Object old = tokenUpdator.getAndSet(this, null);
            return old == CLAIM_TOKEN ? null : old;
        }
    }
}

