/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.security.handlers.SinglePortConfidentialityHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.api.ConfidentialPortManager;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.handlers.ServletAttachments;
import java.net.URI;
import java.net.URISyntaxException;

public class ServletConfidentialityConstraintHandler
extends SinglePortConfidentialityHandler {
    private final ConfidentialPortManager portManager;

    public ServletConfidentialityConstraintHandler(ConfidentialPortManager portManager, HttpHandler next) {
        super(next, -1);
        this.portManager = portManager;
    }

    @Override
    protected boolean confidentialityRequired(HttpServerExchange exchange) {
        TransportGuaranteeType transportGuarantee = exchange.getAttachment(ServletAttachments.ATTACHMENT_KEY).getTransportGuarenteeType();
        return TransportGuaranteeType.CONFIDENTIAL == transportGuarantee || TransportGuaranteeType.INTEGRAL == transportGuarantee;
    }

    @Override
    protected URI getRedirectURI(HttpServerExchange exchange) throws URISyntaxException {
        return super.getRedirectURI(exchange, this.portManager.getConfidentialPort(exchange));
    }
}

