/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.protocol.version00;

import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version00.WebSocket00Channel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import org.xnio.IoFuture;
import org.xnio.Pool;
import org.xnio.channels.ConnectedStreamChannel;

public class Hybi00Handshake
extends Handshake {
    private static final Pattern PATTERN = Pattern.compile("[^0-9]");

    public Hybi00Handshake() {
        super(WebSocketVersion.V00, "MD5", null, Collections.emptySet());
    }

    public Hybi00Handshake(Set<String> subprotocols) {
        super(WebSocketVersion.V00, "MD5", null, subprotocols);
    }

    @Override
    protected void handshakeInternal(final WebSocketHttpExchange exchange) {
        String origin = exchange.getRequestHeader("Sec-WebSocket-Origin");
        if (origin != null) {
            exchange.setResponseHeader("Sec-WebSocket-Origin", origin);
        }
        exchange.setResponseHeader("Sec-WebSocket-Location", Hybi00Handshake.getWebSocketLocation(exchange));
        String protocol = exchange.getRequestHeader("Sec-WebSocket-Protocol");
        if (protocol != null) {
            exchange.setResponseHeader("Sec-WebSocket-Protocol", protocol);
        }
        final String key1 = exchange.getRequestHeader("Sec-WebSocket-Key1");
        final String key2 = exchange.getRequestHeader("Sec-WebSocket-Key2");
        exchange.readRequestData().addNotifier(new IoFuture.Notifier<byte[], Object>(){

            @Override
            public void notify(IoFuture ioFuture, Object attachment) {
                try {
                    byte[] key3 = (byte[])ioFuture.get();
                    byte[] solution = Hybi00Handshake.solve(Hybi00Handshake.this.getHashAlgorithm(), key1, key2, key3);
                    Hybi00Handshake.this.performUpgrade(exchange, solution);
                }
                catch (IOException e) {
                    exchange.close();
                }
            }
        }, null);
    }

    @Override
    public boolean matches(WebSocketHttpExchange exchange) {
        return exchange.getRequestHeader("Sec-WebSocket-Key1") != null && exchange.getRequestHeader("Sec-WebSocket-Key2") != null;
    }

    @Override
    public WebSocketChannel createChannel(WebSocketHttpExchange exchange, ConnectedStreamChannel channel, Pool<ByteBuffer> pool) {
        return new WebSocket00Channel(channel, pool, Hybi00Handshake.getWebSocketLocation(exchange), this.subprotocols, false);
    }

    protected static byte[] solve(String hashAlgorithm, String encodedKey1, String encodedKey2, byte[] key3) {
        return Hybi00Handshake.solve(hashAlgorithm, Hybi00Handshake.decodeKey(encodedKey1), Hybi00Handshake.decodeKey(encodedKey2), key3);
    }

    protected static byte[] solve(String hashAlgorithm, long key1, long key2, byte[] key3) {
        ByteBuffer buffer = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
        buffer.putInt((int)key1);
        buffer.putInt((int)key2);
        buffer.put(key3);
        buffer.rewind();
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm);
            digest.update(buffer);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("error generating hash", e);
        }
    }

    protected static long decodeKey(String encoded) {
        int len = encoded.length();
        int numSpaces = 0;
        for (int i = 0; i < len; ++i) {
            if (encoded.charAt(i) != ' ') continue;
            ++numSpaces;
        }
        String digits = PATTERN.matcher(encoded).replaceAll("");
        long product = Long.parseLong(digits);
        return product / (long)numSpaces;
    }
}

