/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.nio.channels.Channel;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.CloseListenerSettable;
import org.xnio.channels.ReadListenerSettable;
import org.xnio.conduits.TerminateHandler;

public interface ReadReadyHandler
extends TerminateHandler {
    public void readReady();

    public static class ReadyTask
    implements Runnable {
        private final ReadReadyHandler handler;

        public ReadyTask(ReadReadyHandler handler) {
            this.handler = handler;
        }

        @Override
        public void run() {
            this.handler.readReady();
        }
    }

    public static class ChannelListenerHandler<C extends Channel & ReadListenerSettable<C>>
    implements ReadReadyHandler {
        private final C channel;

        public ChannelListenerHandler(C channel) {
            this.channel = channel;
        }

        @Override
        public void forceTermination() {
            IoUtils.safeClose(this.channel);
        }

        @Override
        public void readReady() {
            ChannelListeners.invokeChannelListener(this.channel, ((ReadListenerSettable)this.channel).getReadListener());
        }

        @Override
        public void terminated() {
            ChannelListeners.invokeChannelListener(this.channel, ((CloseListenerSettable)this.channel).getCloseListener());
        }
    }
}

