/*
 * Decompiled with CFR 0.152.
 */
package io.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.NameVirtualHostHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.RedirectHandler;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.websockets.api.WebSocketSessionHandler;
import io.undertow.websockets.core.handler.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.impl.WebSocketSessionConnectionCallback;

public class Handlers {
    public static PathHandler path(HttpHandler defaultHandler) {
        return new PathHandler(defaultHandler);
    }

    public static PathHandler path() {
        return new PathHandler();
    }

    public static NameVirtualHostHandler virtualHost() {
        return new NameVirtualHostHandler();
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler defaultHandler) {
        return new NameVirtualHostHandler().setDefaultHandler(defaultHandler);
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler hostHandler, String ... hostnames) {
        NameVirtualHostHandler handler = new NameVirtualHostHandler();
        for (String host : hostnames) {
            handler.addHost(host, hostHandler);
        }
        return handler;
    }

    public static NameVirtualHostHandler virtualHost(HttpHandler defaultHandler, HttpHandler hostHandler, String ... hostnames) {
        return Handlers.virtualHost(hostHandler, hostnames).setDefaultHandler(defaultHandler);
    }

    public static WebSocketProtocolHandshakeHandler websocket(WebSocketSessionHandler sessionHandler) {
        return new WebSocketProtocolHandshakeHandler(new WebSocketSessionConnectionCallback(sessionHandler));
    }

    public static WebSocketProtocolHandshakeHandler websocket(WebSocketSessionHandler sessionHandler, HttpHandler next) {
        return new WebSocketProtocolHandshakeHandler(new WebSocketSessionConnectionCallback(sessionHandler), next);
    }

    public static ResourceHandler resource(ResourceManager resourceManager) {
        return new ResourceHandler().setResourceManager(resourceManager).setDirectoryListingEnabled(false);
    }

    public static RedirectHandler redirect(String location) {
        return new RedirectHandler(location);
    }

    private Handlers() {
    }
}

