/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.channels.ReadTimeoutStreamSourceChannel;
import io.undertow.channels.WriteTimeoutStreamSinkChannel;
import io.undertow.client.HttpClient;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientConnectionImpl;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.Cancellable;
import org.xnio.ChannelListener;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.Result;
import org.xnio.StreamConnection;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.AssembledConnectedStreamChannel;
import org.xnio.channels.PushBackStreamChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

class HttpClientImpl
extends HttpClient {
    private final OptionMap options;
    private final Pool<ByteBuffer> bufferPool;
    private final Set<HttpClientConnection> connections = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    HttpClientImpl(XnioWorker worker, OptionMap options) {
        super(worker);
        this.options = options;
        this.bufferPool = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 4096, 81920);
    }

    @Override
    public IoFuture<HttpClientConnection> connect(SocketAddress destination, OptionMap optionMap) {
        return this.connect(null, destination, optionMap);
    }

    @Override
    public IoFuture<HttpClientConnection> connect(XnioIoThread ioThread, SocketAddress destination, OptionMap optionMap) {
        final FutureResult<HttpClientConnection> result = new FutureResult<HttpClientConnection>();
        result.addCancelHandler(new Cancellable(){

            @Override
            public Cancellable cancel() {
                result.setCancelled();
                return this;
            }
        });
        ClientConnectionOpenListener openListener = new ClientConnectionOpenListener(result, optionMap);
        IoFuture<StreamConnection> future = ioThread == null ? this.getWorker().openStreamConnection(destination, openListener, optionMap) : ioThread.openStreamConnection(destination, openListener, optionMap);
        future.addNotifier(new IoFuture.HandlingNotifier<StreamConnection, IoFuture<HttpClientConnection>>(){

            @Override
            public void handleCancelled(IoFuture<HttpClientConnection> future) {
                future.cancel();
            }

            @Override
            public void handleFailed(IOException exception, IoFuture<HttpClientConnection> attachment) {
                result.setException(exception);
            }
        }, result.getIoFuture());
        return result.getIoFuture();
    }

    @Override
    public void close() throws IOException {
        for (HttpClientConnection connection : this.connections) {
            connection.close();
        }
    }

    Pool<ByteBuffer> getBufferPool() {
        return this.bufferPool;
    }

    void connectionClosed(HttpClientConnection connection) {
        this.connections.remove(connection);
    }

    class ClientConnectionOpenListener
    implements ChannelListener<StreamConnection> {
        private final Result<HttpClientConnection> result;
        private final OptionMap options;

        ClientConnectionOpenListener(Result<HttpClientConnection> result, OptionMap options) {
            this.result = result;
            this.options = options;
        }

        @Override
        public void handleEvent(StreamConnection channel) {
            StreamSourceChannel readChannel = channel.getSourceChannel();
            StreamSinkChannel writeChannel = channel.getSinkChannel();
            if (channel.supportsOption(Options.READ_TIMEOUT)) {
                readChannel = new ReadTimeoutStreamSourceChannel(readChannel);
            }
            if (channel.supportsOption(Options.WRITE_TIMEOUT)) {
                writeChannel = new WriteTimeoutStreamSinkChannel(writeChannel);
            }
            PushBackStreamChannel pushBackStreamChannel = new PushBackStreamChannel(readChannel);
            AssembledConnectedStreamChannel assembledChannel = channel instanceof SslChannel ? new AssembledConnectedSslStreamChannel((SslChannel)((Object)channel), readChannel, writeChannel) : new AssembledConnectedStreamChannel(channel, readChannel, writeChannel);
            HttpClientConnectionImpl connection = new HttpClientConnectionImpl(assembledChannel, pushBackStreamChannel, this.options, HttpClientImpl.this);
            this.result.setResult(connection);
            HttpClientImpl.this.connections.add(connection);
        }
    }
}

