/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.examples.websockets;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.examples.UndertowExample;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.websockets.api.AbstractAssembledFrameHandler;
import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.api.WebSocketSession;
import io.undertow.websockets.api.WebSocketSessionHandler;
import io.undertow.websockets.spi.WebSocketHttpExchange;

@UndertowExample(value="Web Sockets")
public class WebSocketServer {
    public static void main(String[] args) {
        Undertow server = Undertow.builder().addListener(8080, "localhost").setHandler(Handlers.path().addPath("/myapp", Handlers.websocket(new WebSocketSessionHandler(){

            @Override
            public void onSession(WebSocketSession session, WebSocketHttpExchange exchange) {
                session.setFrameHandler(new AbstractAssembledFrameHandler(){

                    @Override
                    public void onTextFrame(WebSocketSession session, WebSocketFrameHeader header, CharSequence payload) {
                        session.sendText(payload, null);
                    }
                });
            }
        })).addPath("index.html", Handlers.resource(new ClassPathResourceManager(WebSocketServer.class.getClassLoader(), WebSocketServer.class.getPackage()))).addPath("/", Handlers.redirect("http://localhost:8080/index.html"))).build();
        server.start();
    }
}

