/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowMessages;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.xnio.Bits;

public class IPAddressAccessControlHandler
implements HttpHandler {
    private static final Pattern IP4_EXACT = Pattern.compile("(?:\\d{1,3}\\.){3}\\d{1,3}");
    private static final Pattern IP4_WILDCARD = Pattern.compile("(?:(?:\\d{1,3}|\\*)\\.){3}(?:\\d{1,3}|\\*)");
    private static final Pattern IP4_SLASH = Pattern.compile("(?:\\d{1,3}\\.){3}\\d{1,3}\\/\\d\\d?");
    private static final Pattern IP6_EXACT = Pattern.compile("(?:[a-zA-Z0-9]{1,4}:){7}[a-zA-Z0-9]{1,4}");
    private static final Pattern IP6_WILDCARD = Pattern.compile("(?:(?:[a-zA-Z0-9]{1,4}|\\*):){7}(?:[a-zA-Z0-9]{1,4}|\\*)");
    private static final Pattern IP6_SLASH = Pattern.compile("(?:[a-zA-Z0-9]{1,4}:){7}[a-zA-Z0-9]{1,4}\\/\\d{1,3}");
    private volatile HttpHandler next;
    private volatile boolean defaultAllow = false;
    private final List<PeerMatch> ipv6acl = new CopyOnWriteArrayList<PeerMatch>();
    private final List<PeerMatch> ipv4acl = new CopyOnWriteArrayList<PeerMatch>();

    public IPAddressAccessControlHandler(HttpHandler next) {
        this.next = next;
    }

    public IPAddressAccessControlHandler() {
        this.next = ResponseCodeHandler.HANDLE_404;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        InetSocketAddress peer = exchange.getSourceAddress();
        if (this.isAllowed(peer.getAddress())) {
            this.next.handleRequest(exchange);
        } else {
            exchange.setResponseCode(403);
            exchange.endExchange();
        }
    }

    boolean isAllowed(InetAddress address) {
        block3: {
            block2: {
                if (!(address instanceof Inet4Address)) break block2;
                for (PeerMatch rule : this.ipv4acl) {
                    if (!rule.matches(address)) continue;
                    return !rule.isDeny();
                }
                break block3;
            }
            if (!(address instanceof Inet6Address)) break block3;
            for (PeerMatch rule : this.ipv6acl) {
                if (!rule.matches(address)) continue;
                return !rule.isDeny();
            }
        }
        return this.defaultAllow;
    }

    public boolean isDefaultAllow() {
        return this.defaultAllow;
    }

    public IPAddressAccessControlHandler setDefaultAllow(boolean defaultAllow) {
        this.defaultAllow = defaultAllow;
        return this;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public IPAddressAccessControlHandler setNext(HttpHandler next) {
        this.next = next;
        return this;
    }

    public IPAddressAccessControlHandler addAllow(String peer) {
        return this.addRule(peer, false);
    }

    public IPAddressAccessControlHandler addDeny(String peer) {
        return this.addRule(peer, true);
    }

    public IPAddressAccessControlHandler clearRules() {
        this.ipv4acl.clear();
        this.ipv6acl.clear();
        return this;
    }

    private IPAddressAccessControlHandler addRule(String peer, boolean deny) {
        if (IP4_EXACT.matcher(peer).matches()) {
            this.addIpV4ExactMatch(peer, deny);
        } else if (IP4_WILDCARD.matcher(peer).matches()) {
            this.addIpV4WildcardMatch(peer, deny);
        } else if (IP4_SLASH.matcher(peer).matches()) {
            this.addIpV4SlashPrefix(peer, deny);
        } else if (IP6_EXACT.matcher(peer).matches()) {
            this.addIpV6ExactMatch(peer, deny);
        } else if (IP6_WILDCARD.matcher(peer).matches()) {
            this.addIpV6WildcardMatch(peer, deny);
        } else if (IP6_SLASH.matcher(peer).matches()) {
            this.addIpV6SlashPrefix(peer, deny);
        } else {
            throw UndertowMessages.MESSAGES.notAValidIpPattern(peer);
        }
        return this;
    }

    private void addIpV6SlashPrefix(String peer, boolean deny) {
        int i;
        String[] components = peer.split("\\/");
        String[] parts = components[0].split("\\:");
        int maskLen = Integer.parseInt(components[1]);
        assert (parts.length == 8);
        byte[] pattern = new byte[16];
        byte[] mask = new byte[16];
        for (i = 0; i < 8; ++i) {
            int val = Integer.parseInt(parts[i], 16);
            pattern[i * 2] = (byte)(val >> 8);
            pattern[i * 2 + 1] = (byte)(val & 0xFF);
        }
        for (i = 0; i < 16; ++i) {
            if (maskLen > 8) {
                mask[i] = -1;
                maskLen -= 8;
                continue;
            }
            if (maskLen == 0) break;
            mask[i] = (byte)(Bits.intBitMask(8 - maskLen, 7) & 0xFF);
            maskLen = 0;
        }
        this.ipv6acl.add(new PrefixIpV6PeerMatch(deny, peer, mask, pattern));
    }

    private void addIpV4SlashPrefix(String peer, boolean deny) {
        String[] components = peer.split("\\/");
        String[] parts = components[0].split("\\.");
        int maskLen = Integer.parseInt(components[1]);
        int mask = Bits.intBitMask(32 - maskLen, 31);
        int prefix = 0;
        for (int i = 0; i < 4; ++i) {
            prefix <<= 8;
            String part = parts[i];
            int no = Integer.parseInt(part);
            prefix |= no;
        }
        this.ipv4acl.add(new PrefixIpV4PeerMatch(deny, peer, mask, prefix));
    }

    private void addIpV6WildcardMatch(String peer, boolean deny) {
        byte[] pattern = new byte[16];
        byte[] mask = new byte[16];
        String[] parts = peer.split("\\:");
        assert (parts.length == 8);
        for (int i = 0; i < 8; ++i) {
            if (parts[i].equals("*")) continue;
            int val = Integer.parseInt(parts[i], 16);
            pattern[i * 2] = (byte)(val >> 8);
            pattern[i * 2 + 1] = (byte)(val & 0xFF);
            mask[i * 2] = -1;
            mask[i * 2 + 1] = -1;
        }
        this.ipv6acl.add(new PrefixIpV6PeerMatch(deny, peer, mask, pattern));
    }

    private void addIpV4WildcardMatch(String peer, boolean deny) {
        String[] parts = peer.split("\\.");
        int mask = 0;
        int prefix = 0;
        for (int i = 0; i < 4; ++i) {
            mask <<= 8;
            prefix <<= 8;
            String part = parts[i];
            if (part.equals("*")) continue;
            int no = Integer.parseInt(part);
            mask |= 0xFF;
            prefix |= no;
        }
        this.ipv4acl.add(new PrefixIpV4PeerMatch(deny, peer, mask, prefix));
    }

    private void addIpV6ExactMatch(String peer, boolean deny) {
        byte[] bytes = new byte[16];
        String[] parts = peer.split("\\:");
        assert (parts.length == 8);
        for (int i = 0; i < 8; ++i) {
            int val = Integer.parseInt(parts[i], 16);
            bytes[i * 2] = (byte)(val >> 8);
            bytes[i * 2 + 1] = (byte)(val & 0xFF);
        }
        this.ipv6acl.add(new ExactIpV6PeerMatch(deny, peer, bytes));
    }

    private void addIpV4ExactMatch(String peer, boolean deny) {
        String[] parts = peer.split("\\.");
        byte[] bytes = new byte[]{(byte)Integer.parseInt(parts[0]), (byte)Integer.parseInt(parts[1]), (byte)Integer.parseInt(parts[2]), (byte)Integer.parseInt(parts[3])};
        this.ipv4acl.add(new ExactIpV4PeerMatch(deny, peer, bytes));
    }

    static class PrefixIpV6PeerMatch
    extends PeerMatch {
        private final byte[] mask;
        private final byte[] prefix;

        protected PrefixIpV6PeerMatch(boolean deny, String pattern, byte[] mask, byte[] prefix) {
            super(deny, pattern);
            this.mask = mask;
            this.prefix = prefix;
            assert (mask.length == prefix.length);
        }

        @Override
        boolean matches(InetAddress address) {
            byte[] bytes = address.getAddress();
            if (bytes == null) {
                return false;
            }
            if (bytes.length != this.mask.length) {
                return false;
            }
            for (int i = 0; i < this.mask.length; ++i) {
                if ((bytes[i] & this.mask[i]) == this.prefix[i]) continue;
                return false;
            }
            return true;
        }
    }

    private static class PrefixIpV4PeerMatch
    extends PeerMatch {
        private final int mask;
        private final int prefix;

        protected PrefixIpV4PeerMatch(boolean deny, String pattern, int mask, int prefix) {
            super(deny, pattern);
            this.mask = mask;
            this.prefix = prefix;
        }

        @Override
        boolean matches(InetAddress address) {
            byte[] bytes = address.getAddress();
            if (bytes == null) {
                return false;
            }
            int addressInt = (bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF;
            return (addressInt & this.mask) == this.prefix;
        }
    }

    static class ExactIpV6PeerMatch
    extends PeerMatch {
        private final byte[] address;

        protected ExactIpV6PeerMatch(boolean deny, String pattern, byte[] address) {
            super(deny, pattern);
            this.address = address;
        }

        @Override
        boolean matches(InetAddress address) {
            return Arrays.equals(address.getAddress(), this.address);
        }
    }

    static class ExactIpV4PeerMatch
    extends PeerMatch {
        private final byte[] address;

        protected ExactIpV4PeerMatch(boolean deny, String pattern, byte[] address) {
            super(deny, pattern);
            this.address = address;
        }

        @Override
        boolean matches(InetAddress address) {
            return Arrays.equals(address.getAddress(), this.address);
        }
    }

    static abstract class PeerMatch {
        private final boolean deny;
        private final String pattern;

        protected PeerMatch(boolean deny, String pattern) {
            this.deny = deny;
            this.pattern = pattern;
        }

        abstract boolean matches(InetAddress var1);

        boolean isDeny() {
            return this.deny;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + "deny=" + this.deny + ", pattern='" + this.pattern + '\'' + '}';
        }
    }
}

