/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Deque;

public class PathParameterSessionConfig
implements SessionConfig {
    private final String name;

    public PathParameterSessionConfig(String name) {
        this.name = name;
    }

    public PathParameterSessionConfig() {
        this("JSESSIONID");
    }

    @Override
    public void setSessionId(HttpServerExchange exchange, String sessionId) {
    }

    @Override
    public void clearSession(HttpServerExchange exchange, String sessionId) {
    }

    @Override
    public String findSessionId(HttpServerExchange exchange) {
        Deque<String> stringDeque = exchange.getPathParameters().get(this.name);
        if (stringDeque == null) {
            return null;
        }
        return stringDeque.getFirst();
    }

    @Override
    public String rewriteUrl(String originalUrl, String sessionId) {
        try {
            int pos = originalUrl.indexOf("?");
            if (pos != -1) {
                return originalUrl.substring(0, pos) + ";" + this.name + "=" + URLEncoder.encode(sessionId, "UTF-8") + originalUrl.substring(pos);
            }
            return originalUrl + ";" + this.name + "=" + URLEncoder.encode(sessionId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

