/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.DefaultServletConfig;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.Filters;
import io.undertow.servlet.core.ManagedFilter;
import io.undertow.servlet.core.ManagedServlet;
import io.undertow.servlet.core.Servlets;
import io.undertow.servlet.handlers.DefaultServlet;
import io.undertow.servlet.handlers.FilterHandler;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletHandler;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatchesData;
import io.undertow.servlet.handlers.security.ServletSecurityRoleHandler;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;

public class ServletPathMatches {
    public static final String DEFAULT_SERVLET_NAME = "default";
    private final Deployment deployment;
    private volatile ServletPathMatchesData data;

    public ServletPathMatches(Deployment deployment) {
        this.deployment = deployment;
    }

    public ServletChain getServletHandlerByName(String name) {
        return this.getData().getServletHandlerByName(name);
    }

    public ServletPathMatch getServletHandlerByExactPath(String path) {
        return this.getData().getServletHandlerByExactPath(path);
    }

    public ServletPathMatch getServletHandlerByPath(String path) {
        return this.getData().getServletHandlerByPath(path);
    }

    public void invalidate() {
        this.data = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServletPathMatchesData getData() {
        ServletPathMatchesData data = this.data;
        if (data != null) {
            return data;
        }
        ServletPathMatches servletPathMatches = this;
        synchronized (servletPathMatches) {
            if (this.data != null) {
                return this.data;
            }
            this.data = this.setupServletChains();
            return this.data;
        }
    }

    private ServletPathMatchesData setupServletChains() {
        ServletChain defaultHandler = null;
        ServletHandler defaultServlet = null;
        Servlets servlets = this.deployment.getServlets();
        Filters filters = this.deployment.getFilters();
        HashMap<String, ServletHandler> extensionServlets = new HashMap<String, ServletHandler>();
        HashMap<String, ServletHandler> pathServlets = new HashMap<String, ServletHandler>();
        HashSet<String> pathMatches = new HashSet<String>();
        HashSet<String> extensionMatches = new HashSet<String>();
        DeploymentInfo deploymentInfo = this.deployment.getDeploymentInfo();
        for (FilterMappingInfo filterMappingInfo : deploymentInfo.getFilterMappings()) {
            if (filterMappingInfo.getMappingType() != FilterMappingInfo.MappingType.URL) continue;
            String string = filterMappingInfo.getMapping();
            if (!string.startsWith("*.")) {
                pathMatches.add(string);
                continue;
            }
            extensionMatches.add(string.substring(2));
        }
        for (Map.Entry entry : deploymentInfo.getServlets().entrySet()) {
            ServletInfo servletInfo = (ServletInfo)entry.getValue();
            ServletHandler handler = servlets.addServlet(servletInfo);
            for (String path : ((ServletInfo)entry.getValue()).getMappings()) {
                if (path.equals("/")) {
                    pathMatches.add("/*");
                    if (pathServlets.containsKey("/*") || defaultServlet != null) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path);
                    }
                    defaultServlet = handler;
                    defaultHandler = ServletPathMatches.servletChain(handler, handler.getManagedServlet(), null);
                    continue;
                }
                if (!path.startsWith("*.")) {
                    if (path.isEmpty()) {
                        path = "/";
                    }
                    pathMatches.add(path);
                    if (pathServlets.containsKey(path)) {
                        throw UndertowServletMessages.MESSAGES.twoServletsWithSameMapping(path);
                    }
                    pathServlets.put(path, handler);
                    continue;
                }
                String ext = path.substring(2);
                extensionMatches.add(ext);
                extensionServlets.put(ext, handler);
            }
        }
        if (defaultServlet == null) {
            DefaultServletConfig config = deploymentInfo.getDefaultServletConfig() == null ? new DefaultServletConfig() : deploymentInfo.getDefaultServletConfig();
            DefaultServlet defaultServlet2 = new DefaultServlet(this.deployment, config, deploymentInfo.getWelcomePages());
            ServletHandler servletHandler = servlets.addServlet(new ServletInfo(DEFAULT_SERVLET_NAME, DefaultServlet.class, new ImmediateInstanceFactory<DefaultServlet>(defaultServlet2)));
            pathMatches.add("/*");
            defaultServlet = servletHandler;
            defaultHandler = new ServletChain(defaultServlet, servletHandler.getManagedServlet(), null);
        }
        ServletPathMatchesData.Builder builder = ServletPathMatchesData.builder();
        for (String string : pathMatches) {
            MatchData targetServletMatch = ServletPathMatches.resolveServletForPath(string, pathServlets);
            HashMap<DispatcherType, List<ManagedFilter>> noExtension = new HashMap<DispatcherType, List<ManagedFilter>>();
            HashMap extension = new HashMap();
            for (String ext : extensionMatches) {
                extension.put(ext, new HashMap());
            }
            for (FilterMappingInfo filterMapping : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter = filters.getManagedFilter(filterMapping.getFilterName());
                if (filterMapping.getMappingType() == FilterMappingInfo.MappingType.SERVLET) {
                    if (targetServletMatch.handler == null || !filterMapping.getMapping().equals(targetServletMatch.handler.getManagedServlet().getServletInfo().getName())) continue;
                    ServletPathMatches.addToListMap(noExtension, filterMapping.getDispatcher(), filter);
                    for (Map l : extension.values()) {
                        ServletPathMatches.addToListMap(l, filterMapping.getDispatcher(), filter);
                    }
                    continue;
                }
                if (filterMapping.getMapping().isEmpty() || !filterMapping.getMapping().startsWith("*.")) {
                    if (!ServletPathMatches.isFilterApplicable(string, filterMapping.getMapping())) continue;
                    ServletPathMatches.addToListMap(noExtension, filterMapping.getDispatcher(), filter);
                    for (Map l : extension.values()) {
                        ServletPathMatches.addToListMap(l, filterMapping.getDispatcher(), filter);
                    }
                    continue;
                }
                ServletPathMatches.addToListMap((Map)extension.get(filterMapping.getMapping().substring(2)), filterMapping.getDispatcher(), filter);
            }
            if (string.endsWith("/*")) {
                String prefix = string.substring(0, string.length() - 2);
                builder.addPrefixMatch(prefix, this.createHandler(defaultHandler, defaultServlet, deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath));
                for (Map.Entry entry : extension.entrySet()) {
                    ServletHandler pathServlet = targetServletMatch.handler;
                    String pathMatch = targetServletMatch.matchedPath;
                    if (pathServlet == null) {
                        pathServlet = (ServletHandler)extensionServlets.get(entry.getKey());
                    }
                    if (pathServlet == null) {
                        pathServlet = defaultServlet;
                    }
                    HttpHandler handler = pathServlet;
                    if (!((Map)entry.getValue()).isEmpty()) {
                        handler = new FilterHandler((Map)entry.getValue(), deploymentInfo.isAllowNonStandardWrappers(), handler);
                    }
                    builder.addExtensionMatch(prefix, (String)entry.getKey(), ServletPathMatches.servletChain(handler, pathServlet.getManagedServlet(), pathMatch));
                }
                continue;
            }
            if (string.isEmpty()) {
                builder.addExactMatch("/", this.createHandler(defaultHandler, defaultServlet, deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath));
                continue;
            }
            String lastSegment = string.substring(string.lastIndexOf(47));
            if (lastSegment.contains(".")) {
                String ext;
                ext = lastSegment.substring(lastSegment.lastIndexOf(46) + 1);
                if (extension.containsKey(ext)) {
                    Map extMap = (Map)extension.get(ext);
                    builder.addExactMatch(string, this.createHandler(defaultHandler, defaultServlet, deploymentInfo, targetServletMatch.handler, extMap, targetServletMatch.matchedPath));
                    continue;
                }
                builder.addExactMatch(string, this.createHandler(defaultHandler, defaultServlet, deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath));
                continue;
            }
            builder.addExactMatch(string, this.createHandler(defaultHandler, defaultServlet, deploymentInfo, targetServletMatch.handler, noExtension, targetServletMatch.matchedPath));
        }
        for (Map.Entry<String, ServletHandler> entry : servlets.getServletHandlers().entrySet()) {
            HashMap<DispatcherType, List<ManagedFilter>> filtersByDispatcher = new HashMap<DispatcherType, List<ManagedFilter>>();
            for (FilterMappingInfo filterMapping : deploymentInfo.getFilterMappings()) {
                ManagedFilter filter = filters.getManagedFilter(filterMapping.getFilterName());
                if (filterMapping.getMappingType() != FilterMappingInfo.MappingType.SERVLET || !filterMapping.getMapping().equals(entry.getKey())) continue;
                ServletPathMatches.addToListMap(filtersByDispatcher, filterMapping.getDispatcher(), filter);
            }
            if (filtersByDispatcher.isEmpty()) {
                builder.addNameMatch(entry.getKey(), ServletPathMatches.servletChain(entry.getValue(), entry.getValue().getManagedServlet(), null));
                continue;
            }
            builder.addNameMatch(entry.getKey(), ServletPathMatches.servletChain(new FilterHandler(filtersByDispatcher, deploymentInfo.isAllowNonStandardWrappers(), entry.getValue()), entry.getValue().getManagedServlet(), null));
        }
        builder.setDefaultServlet(defaultHandler);
        return builder.build();
    }

    private ServletChain createHandler(ServletChain defaultHandler, ServletHandler defaultServlet, DeploymentInfo deploymentInfo, ServletHandler targetServlet, Map<DispatcherType, List<ManagedFilter>> noExtension, String servletPath) {
        ServletChain initialHandler;
        if (noExtension.isEmpty()) {
            initialHandler = targetServlet != null ? ServletPathMatches.servletChain(targetServlet, targetServlet.getManagedServlet(), servletPath) : defaultHandler;
        } else if (targetServlet != null) {
            FilterHandler handler = new FilterHandler(noExtension, deploymentInfo.isAllowNonStandardWrappers(), targetServlet);
            initialHandler = ServletPathMatches.servletChain(handler, targetServlet.getManagedServlet(), servletPath);
        } else {
            FilterHandler handler = new FilterHandler(noExtension, deploymentInfo.isAllowNonStandardWrappers(), defaultServlet);
            initialHandler = ServletPathMatches.servletChain(handler, defaultServlet.getManagedServlet(), servletPath);
        }
        return initialHandler;
    }

    private static MatchData resolveServletForPath(String path, Map<String, ServletHandler> pathServlets) {
        if (pathServlets.containsKey(path)) {
            if (path.endsWith("/*")) {
                String base = path.substring(0, path.length() - 2);
                return new MatchData(pathServlets.get(path), base);
            }
            return new MatchData(pathServlets.get(path), path);
        }
        String match = null;
        ServletHandler servlet = null;
        for (Map.Entry<String, ServletHandler> entry : pathServlets.entrySet()) {
            String key = entry.getKey();
            if (!key.endsWith("/*")) continue;
            String base = key.substring(0, key.length() - 2);
            if (match != null && base.length() <= match.length() || !path.startsWith(base)) continue;
            match = base;
            servlet = entry.getValue();
        }
        if (servlet != null) {
            return new MatchData(servlet, match);
        }
        return new MatchData(null, null);
    }

    private static boolean isFilterApplicable(String path, String filterPath) {
        if (path.isEmpty()) {
            return filterPath.equals("/*") || filterPath.equals("/");
        }
        if (filterPath.endsWith("/*")) {
            String baseFilterPath = filterPath.substring(0, filterPath.length() - 1);
            return path.startsWith(baseFilterPath);
        }
        return filterPath.equals(path);
    }

    private static <K, V> void addToListMap(Map<K, List<V>> map, K key, V value) {
        List<V> list = map.get(key);
        if (list == null) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        list.add(value);
    }

    private static ServletChain servletChain(HttpHandler next, ManagedServlet managedServlet, String servletPath) {
        HttpHandler servletHandler = new ServletSecurityRoleHandler(next);
        servletHandler = ServletPathMatches.wrapHandlers(servletHandler, managedServlet.getServletInfo().getHandlerChainWrappers());
        return new ServletChain(servletHandler, managedServlet, servletPath);
    }

    private static HttpHandler wrapHandlers(HttpHandler wrapee, List<HandlerWrapper> wrappers) {
        HttpHandler current = wrapee;
        for (HandlerWrapper wrapper : wrappers) {
            current = wrapper.wrap(current);
        }
        return current;
    }

    private static class MatchData {
        final ServletHandler handler;
        final String matchedPath;

        private MatchData(ServletHandler handler, String matchedPath) {
            this.handler = handler;
            this.matchedPath = matchedPath;
        }
    }
}

