/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.auth.shiro;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.ext.auth.User;
import io.vertx.reactivex.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.auth.shiro.ShiroAuthOptions;
import io.vertx.ext.auth.shiro.ShiroAuthRealmType;
import io.vertx.reactivex.ext.auth.AuthProvider;

/**
 * Factory interface for creating Apache Shiro based {@link io.vertx.reactivex.ext.auth.AuthProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.shiro.ShiroAuth original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.auth.shiro.ShiroAuth.class)
public class ShiroAuth extends AuthProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShiroAuth that = (ShiroAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<ShiroAuth> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new ShiroAuth((io.vertx.ext.auth.shiro.ShiroAuth) obj),
    ShiroAuth::getDelegate
  );

  private final io.vertx.ext.auth.shiro.ShiroAuth delegate;
  
  public ShiroAuth(io.vertx.ext.auth.shiro.ShiroAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.auth.shiro.ShiroAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a Shiro auth provider
   * @param vertx the Vert.x instance
   * @param realmType the Shiro realm type
   * @param config the config
   * @return the auth provider
   */
  public static ShiroAuth create(Vertx vertx, ShiroAuthRealmType realmType, JsonObject config) { 
    ShiroAuth ret = ShiroAuth.newInstance(io.vertx.ext.auth.shiro.ShiroAuth.create(vertx.getDelegate(), realmType, config));
    return ret;
  }

  /**
   * Create a Shiro auth provider
   * @param vertx the Vert.x instance
   * @param options the Shiro configuration options
   * @return the auth provider
   */
  public static ShiroAuth create(Vertx vertx, ShiroAuthOptions options) { 
    ShiroAuth ret = ShiroAuth.newInstance(io.vertx.ext.auth.shiro.ShiroAuth.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Set the role prefix to distinguish from permissions when checking for isPermitted requests.
   * @param rolePrefix a Prefix e.g.: "role:"
   * @return a reference to this for fluency
   */
  public ShiroAuth setRolePrefix(String rolePrefix) { 
    ShiroAuth ret = ShiroAuth.newInstance(delegate.setRolePrefix(rolePrefix));
    return ret;
  }


  public static  ShiroAuth newInstance(io.vertx.ext.auth.shiro.ShiroAuth arg) {
    return arg != null ? new ShiroAuth(arg) : null;
  }
}
