/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class CBOR
implements AutoCloseable {
    public static final int TYPE_UNSIGNED_INTEGER = 0;
    public static final int TYPE_NEGATIVE_INTEGER = 1;
    public static final int TYPE_BYTE_STRING = 2;
    public static final int TYPE_TEXT_STRING = 3;
    public static final int TYPE_ARRAY = 4;
    public static final int TYPE_MAP = 5;
    public static final int TYPE_TAG = 6;
    public static final int TYPE_FLOAT_SIMPLE = 7;
    public static final int ONE_BYTE = 24;
    public static final int TWO_BYTES = 25;
    public static final int FOUR_BYTES = 26;
    public static final int EIGHT_BYTES = 27;
    public static final int FALSE = 20;
    public static final int TRUE = 21;
    public static final int NULL = 22;
    public static final int UNDEFINED = 23;
    public static final int HALF_PRECISION_FLOAT = 25;
    public static final int SINGLE_PRECISION_FLOAT = 26;
    public static final int DOUBLE_PRECISION_FLOAT = 27;
    public static final int BREAK = 31;
    public static final long TAG_STANDARD_DATE_TIME = 0L;
    public static final long TAG_EPOCH_DATE_TIME = 1L;
    public static final long TAG_POSITIVE_BIGINT = 2L;
    public static final long TAG_NEGATIVE_BIGINT = 3L;
    public static final long TAG_DECIMAL_FRACTION = 4L;
    public static final long TAG_BIGDECIMAL = 5L;
    public static final long TAG_EXPECTED_BASE64_URL_ENCODED = 21L;
    public static final long TAG_EXPECTED_BASE64_ENCODED = 22L;
    public static final long TAG_EXPECTED_BASE16_ENCODED = 23L;
    public static final long TAG_CBOR_ENCODED = 24L;
    public static final long TAG_URI = 32L;
    public static final long TAG_BASE64_URL_ENCODED = 33L;
    public static final long TAG_BASE64_ENCODED = 34L;
    public static final long TAG_REGEXP = 35L;
    public static final long TAG_MIME_MESSAGE = 36L;
    public static final long TAG_CBOR_MARKER = 55799L;
    private final PushbackInputStream m_is;
    private final int length;

    public CBOR(byte[] data) {
        Objects.requireNonNull(data, "'data' cannot be null");
        this.length = data.length;
        this.m_is = new PushbackInputStream(new ByteArrayInputStream(data));
    }

    @Override
    public void close() throws IOException {
        this.m_is.close();
    }

    private long readArrayLength() throws IOException {
        return this.readMajorTypeWithSize(4);
    }

    private Boolean readBoolean() throws IOException {
        int b = this.readMajorType(7);
        if (b != 20 && b != 21) {
            throw new IOException("Unexpected boolean value: " + b);
        }
        return b == 21;
    }

    private Object readBreak() throws IOException {
        this.readMajorTypeExact(31);
        return null;
    }

    private byte[] readByteString() throws IOException {
        long len = this.readMajorTypeWithSize(2);
        if (len < 0L) {
            throw new IOException("Infinite-length byte strings not supported!");
        }
        if (len > Integer.MAX_VALUE) {
            throw new IOException("String length too long!");
        }
        return this.readFully(new byte[(int)len]);
    }

    private Double readDouble() throws IOException {
        this.readMajorTypeExact(27);
        return Double.longBitsToDouble(this.readUInt64());
    }

    private Float readFloat() throws IOException {
        this.readMajorTypeExact(26);
        return Float.valueOf(Float.intBitsToFloat((int)this.readUInt32()));
    }

    private Double readHalfPrecisionFloat() throws IOException {
        this.readMajorTypeExact(25);
        int half = this.readUInt16();
        int exp = half >> 10 & 0x1F;
        int mant = half & 0x3FF;
        double val = exp == 0 ? (double)mant * Math.pow(2.0, -24.0) : (exp != 31 ? (double)(mant + 1024) * Math.pow(2.0, exp - 25) : (mant != 0 ? Double.NaN : Double.POSITIVE_INFINITY));
        return (half & 0x8000) == 0 ? val : -val;
    }

    private Long readInt() throws IOException {
        int ib = this.m_is.read();
        long ui = this.expectIntegerType(ib);
        return ui ^ this.readUInt(ib & 0x1F, false);
    }

    private long readMapLength() throws IOException {
        return this.readMajorTypeWithSize(5);
    }

    private Object readNull() throws IOException {
        this.readMajorTypeExact(22);
        return null;
    }

    private Byte readSimpleValue() throws IOException {
        this.readMajorTypeExact(24);
        return (byte)this.readUInt8();
    }

    private Long readTag() throws IOException {
        return this.readUInt(this.readMajorType(6), false);
    }

    private String readTextString() throws IOException {
        long len = this.readMajorTypeWithSize(3);
        if (len < 0L) {
            throw new IOException("Infinite-length text strings not supported!");
        }
        if (len > Integer.MAX_VALUE) {
            throw new IOException("String length too long!");
        }
        return new String(this.readFully(new byte[(int)len]), StandardCharsets.UTF_8);
    }

    private Object readUndefined() throws IOException {
        this.readMajorTypeExact(23);
        return null;
    }

    private long expectIntegerType(int ib) throws IOException {
        int majorType = (ib & 0xFF) >>> 5;
        if (majorType != 0 && majorType != 1) {
            throw new IOException("Unexpected type: [" + majorType + "]: expected [" + 0 + " | " + 1 + "]");
        }
        return -majorType;
    }

    private int readMajorType(int majorType) throws IOException {
        int ib = this.m_is.read();
        if (majorType != (ib >>> 5 & 7)) {
            throw new IOException("Unexpected type: [" + ib + "]: expected [" + majorType + "]");
        }
        return ib & 0x1F;
    }

    private void readMajorTypeExact(int subtype) throws IOException {
        int st = this.readMajorType(7);
        if ((st ^ subtype) != 0) {
            throw new IOException("Unexpected subtype [" + st + "]: expected [" + subtype + "]");
        }
    }

    private long readMajorTypeWithSize(int majorType) throws IOException {
        return this.readUInt(this.readMajorType(majorType), true);
    }

    private long readUInt(int length, boolean breakAllowed) throws IOException {
        long result = -1L;
        if (length < 24) {
            result = length;
        } else if (length == 24) {
            result = this.readUInt8();
        } else if (length == 25) {
            result = this.readUInt16();
        } else if (length == 26) {
            result = this.readUInt32();
        } else if (length == 27) {
            result = this.readUInt64();
        } else if (breakAllowed && length == 31) {
            return -1L;
        }
        if (result < 0L) {
            throw new IOException("Not well-formed CBOR integer found, invalid length: " + result);
        }
        return result;
    }

    private int readUInt16() throws IOException {
        byte[] buf = this.readFully(new byte[2]);
        return (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
    }

    private long readUInt32() throws IOException {
        byte[] buf = this.readFully(new byte[4]);
        return ((long)(buf[0] & 0xFF) << 24 | (long)((buf[1] & 0xFF) << 16) | (long)((buf[2] & 0xFF) << 8) | (long)(buf[3] & 0xFF)) & 0xFFFFFFFFL;
    }

    private long readUInt64() throws IOException {
        byte[] buf = this.readFully(new byte[8]);
        return ((long)buf[0] & 0xFFL) << 56 | ((long)buf[1] & 0xFFL) << 48 | ((long)buf[2] & 0xFFL) << 40 | ((long)buf[3] & 0xFFL) << 32 | ((long)buf[4] & 0xFFL) << 24 | ((long)buf[5] & 0xFFL) << 16 | ((long)buf[6] & 0xFFL) << 8 | (long)buf[7] & 0xFFL;
    }

    private int readUInt8() throws IOException {
        return this.m_is.read() & 0xFF;
    }

    private byte[] readFully(byte[] buf) throws IOException {
        int count;
        int len = buf.length;
        int off = 0;
        for (int n = 0; n < len; n += count) {
            count = this.m_is.read(buf, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return buf;
    }

    public <T> T read() throws IOException {
        return this.read(-1, -1);
    }

    public <T> T read(int mt) throws IOException {
        return this.read(mt, -1);
    }

    public <T> T read(int mt, int subtype) throws IOException {
        int p = this.m_is.read();
        if (p < 0) {
            throw new EOFException("end of CBOR data");
        }
        this.m_is.unread(p);
        if (mt == -1) {
            mt = (p & 0xFF) >>> 5;
        }
        if (subtype == -1) {
            subtype = p & 0x1F;
        }
        if (mt != (p & 0xFF) >>> 5) {
            throw new ClassCastException("Cannot cast CBOR value to type: " + mt);
        }
        if (subtype != (p & 0x1F)) {
            throw new ClassCastException("Cannot cast CBOR value to sub-type: " + mt);
        }
        switch (mt) {
            case 0: 
            case 1: {
                return (T)this.readInt();
            }
            case 2: {
                return (T)this.readByteString();
            }
            case 3: {
                return (T)this.readTextString();
            }
            case 4: {
                long len = this.readArrayLength();
                JsonArray result = new JsonArray();
                int i = 0;
                while (len < 0L || (long)i < len) {
                    T item = this.read();
                    if (len < 0L && item == null) break;
                    result.add(item);
                    ++i;
                }
                return (T)result;
            }
            case 5: {
                long len = this.readMapLength();
                JsonObject result = new JsonObject();
                for (long i = 0L; len < 0L || i < len; ++i) {
                    T key = this.read();
                    if (len < 0L && key == null) break;
                    result.put(key.toString(), this.read());
                }
                return (T)result;
            }
            case 6: {
                return (T)this.readTag();
            }
            case 7: {
                if (subtype < 24) {
                    if (subtype == 20 || subtype == 21) {
                        return (T)this.readBoolean();
                    }
                    if (subtype == 22) {
                        return (T)this.readNull();
                    }
                    if (subtype != 23) break;
                    return (T)this.readUndefined();
                }
                if (subtype == 24) {
                    return (T)this.readSimpleValue();
                }
                if (subtype == 25) {
                    return (T)this.readHalfPrecisionFloat();
                }
                if (subtype == 26) {
                    return (T)this.readFloat();
                }
                if (subtype == 27) {
                    return (T)this.readDouble();
                }
                if (subtype != 31) break;
                return (T)this.readBreak();
            }
        }
        throw new IllegalStateException("Unsupported type: " + mt);
    }

    public int offset() throws IOException {
        return this.length - this.m_is.available();
    }
}

