/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker.impl;

import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.circuitbreaker.impl.CircuitBreakerImpl;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.HdrHistogram.Histogram;

public class CircuitBreakerMetrics {
    private final long rollingWindow;
    private final Vertx vertx;
    private final long timer;
    private final CircuitBreakerImpl circuitBreaker;
    private final String node;
    private final long circuitBreakerResetTimeout;
    private final long circuitBreakerTimeout;
    private int calls = 0;
    private int failures = 0;
    private int success = 0;
    private int timeout = 0;
    private int exceptions = 0;
    private List<Operation> window = new ArrayList<Operation>();
    private Histogram statistics = new Histogram(3);

    CircuitBreakerMetrics(Vertx vertx, CircuitBreakerImpl circuitBreaker, CircuitBreakerOptions options) {
        this.vertx = vertx;
        this.circuitBreaker = circuitBreaker;
        this.circuitBreakerTimeout = circuitBreaker.options().getTimeout();
        this.circuitBreakerResetTimeout = circuitBreaker.options().getResetTimeout();
        this.rollingWindow = options.getMetricsRollingWindow();
        this.timer = vertx.setPeriodic(this.rollingWindow, l -> this.evictOutdatedCalls());
        this.node = vertx.isClustered() ? ((VertxInternal)vertx).getClusterManager().getNodeID() : "local";
    }

    private synchronized void evictOutdatedCalls() {
        long beginningOfTheWindow = System.nanoTime() - this.rollingWindow * 1000000L;
        List toRemove = this.window.stream().filter(operation -> operation.begin < beginningOfTheWindow).collect(Collectors.toList());
        this.window.removeAll(toRemove);
    }

    public void close() {
        this.vertx.cancelTimer(this.timer);
    }

    Operation enqueue() {
        return new Operation();
    }

    public synchronized void complete(Operation operation) {
        this.window.add(operation);
        this.statistics.recordValue(operation.durationInMs());
        ++this.calls;
        if (operation.exception) {
            ++this.exceptions;
        } else if (operation.complete) {
            ++this.success;
        } else if (operation.timeout) {
            ++this.timeout;
        } else if (operation.failed) {
            ++this.failures;
        }
    }

    public synchronized JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("resetTimeout", Long.valueOf(this.circuitBreakerResetTimeout));
        json.put("timeout", Long.valueOf(this.circuitBreakerTimeout));
        json.put("metricRollingWindow", Long.valueOf(this.rollingWindow));
        json.put("name", this.circuitBreaker.name());
        json.put("node", this.node);
        json.put("state", (Enum)this.circuitBreaker.state());
        json.put("failures", Long.valueOf(this.circuitBreaker.failureCount()));
        json.put("totalErrorCount", Integer.valueOf(this.failures + this.exceptions + this.timeout));
        json.put("totalSuccessCount", Integer.valueOf(this.success));
        json.put("totalTimeoutCount", Integer.valueOf(this.timeout));
        json.put("totalExceptionCount", Integer.valueOf(this.exceptions));
        json.put("totalFailureCount", Integer.valueOf(this.failures));
        json.put("totalOperationCount", Integer.valueOf(this.calls));
        if (this.calls == 0) {
            json.put("totalSuccessPercentage", Integer.valueOf(0));
            json.put("totalErrorPercentage", Integer.valueOf(0));
        } else {
            json.put("totalSuccessPercentage", Double.valueOf((double)this.success / (double)this.calls * 100.0));
            json.put("totalErrorPercentage", Double.valueOf((double)(this.failures + this.exceptions + this.timeout) / (double)this.calls * 100.0));
        }
        this.addLatency(json, this.statistics, "total");
        int rollingException = 0;
        int rollingFailure = 0;
        int rollingSuccess = 0;
        int rollingTimeout = 0;
        int rollingFallbackSuccess = 0;
        int rollingFallbackFailure = 0;
        int rollingShortCircuited = 0;
        Histogram rollingStatistic = new Histogram(3);
        for (Operation op : this.window) {
            rollingStatistic.recordValue(op.durationInMs());
            if (op.complete) {
                ++rollingSuccess;
            } else if (op.failed) {
                ++rollingFailure;
            } else if (op.exception) {
                ++rollingException;
            } else if (op.timeout) {
                ++rollingTimeout;
            }
            if (op.fallbackSucceed) {
                ++rollingFallbackSuccess;
            } else if (op.fallbackFailed) {
                ++rollingFallbackFailure;
            }
            if (!op.shortCircuited) continue;
            ++rollingShortCircuited;
        }
        json.put("rollingOperationCount", Integer.valueOf(this.window.size()));
        json.put("rollingErrorCount", Integer.valueOf(rollingException + rollingFailure + rollingTimeout));
        json.put("rollingSuccessCount", Integer.valueOf(rollingSuccess));
        json.put("rollingTimeoutCount", Integer.valueOf(rollingTimeout));
        json.put("rollingExceptionCount", Integer.valueOf(rollingException));
        json.put("rollingFailureCount", Integer.valueOf(rollingFailure));
        if (this.calls == 0) {
            json.put("rollingSuccessPercentage", Integer.valueOf(0));
            json.put("rollingErrorPercentage", Integer.valueOf(0));
        } else {
            json.put("rollingSuccessPercentage", Double.valueOf((double)rollingSuccess / (double)this.calls * 100.0));
            json.put("rollingErrorPercentage", Double.valueOf((double)(rollingException + rollingFailure + rollingTimeout) / (double)this.calls * 100.0));
        }
        json.put("rollingFallbackSuccessCount", Integer.valueOf(rollingFallbackSuccess));
        json.put("rollingFallbackFailureCount", Integer.valueOf(rollingFallbackFailure));
        json.put("rollingShortCircuitedCount", Integer.valueOf(rollingShortCircuited));
        this.addLatency(json, rollingStatistic, "rolling");
        return json;
    }

    private void addLatency(JsonObject json, Histogram histogram, String prefix) {
        json.put(prefix + "LatencyMean", Double.valueOf(histogram.getMean()));
        json.put(prefix + "Latency", new JsonObject().put("0", Long.valueOf(histogram.getValueAtPercentile(0.0))).put("25", Long.valueOf(histogram.getValueAtPercentile(25.0))).put("50", Long.valueOf(histogram.getValueAtPercentile(50.0))).put("75", Long.valueOf(histogram.getValueAtPercentile(75.0))).put("90", Long.valueOf(histogram.getValueAtPercentile(90.0))).put("95", Long.valueOf(histogram.getValueAtPercentile(95.0))).put("99", Long.valueOf(histogram.getValueAtPercentile(99.0))).put("99.5", Long.valueOf(histogram.getValueAtPercentile(99.5))).put("100", Long.valueOf(histogram.getValueAtPercentile(100.0))));
    }

    class Operation {
        final long begin = System.nanoTime();
        private long end;
        private boolean complete;
        private boolean failed;
        private boolean timeout;
        private boolean exception;
        private boolean fallbackFailed;
        private boolean fallbackSucceed;
        private boolean shortCircuited;

        Operation() {
        }

        synchronized void complete() {
            this.end = System.nanoTime();
            this.complete = true;
            CircuitBreakerMetrics.this.complete(this);
        }

        synchronized void failed() {
            if (this.timeout || this.exception) {
                return;
            }
            this.end = System.nanoTime();
            this.failed = true;
            CircuitBreakerMetrics.this.complete(this);
        }

        synchronized void timeout() {
            this.end = System.nanoTime();
            this.failed = false;
            this.timeout = true;
            CircuitBreakerMetrics.this.complete(this);
        }

        synchronized void error() {
            this.end = System.nanoTime();
            this.failed = false;
            this.exception = true;
            CircuitBreakerMetrics.this.complete(this);
        }

        synchronized void fallbackFailed() {
            this.fallbackFailed = true;
        }

        synchronized void fallbackSucceed() {
            this.fallbackSucceed = true;
        }

        synchronized void shortCircuited() {
            this.end = System.nanoTime();
            this.shortCircuited = true;
            CircuitBreakerMetrics.this.complete(this);
        }

        synchronized long durationInMs() {
            return (this.end - this.begin) / 1000000L;
        }
    }
}

