/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.circuitbreaker;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.impl.Arguments;
import java.util.concurrent.ThreadLocalRandom;

@VertxGen
@FunctionalInterface
public interface RetryPolicy {
    public static RetryPolicy constantDelay(long delay) {
        Arguments.require((delay > 0L ? 1 : 0) != 0, (String)"delay must be strictly positive");
        return (failure, retryCount) -> delay;
    }

    public static RetryPolicy linearDelay(long initialDelay, long maxDelay) {
        Arguments.require((initialDelay > 0L ? 1 : 0) != 0, (String)"initialDelay must be strictly positive");
        Arguments.require((maxDelay >= initialDelay ? 1 : 0) != 0, (String)"maxDelay must be greater than initialDelay");
        return (failure, retryCount) -> Math.min(maxDelay, initialDelay * (long)retryCount);
    }

    public static RetryPolicy exponentialDelayWithJitter(long initialDelay, long maxDelay) {
        Arguments.require((initialDelay > 0L ? 1 : 0) != 0, (String)"initialDelay must be strictly positive");
        Arguments.require((maxDelay >= initialDelay ? 1 : 0) != 0, (String)"maxDelay must be greater than initialDelay");
        return (failure, retryCount) -> {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            long delay = initialDelay * (1L << retryCount);
            return random.nextLong(0L, delay < 0L ? maxDelay : Math.min(maxDelay, delay));
        };
    }

    public long delay(Throwable var1, int var2);
}

