package io.vertx.groovy.ext.consul;
import groovy.lang.MetaMethod;
import org.codehaus.groovy.runtime.m12n.ExtensionModule;
import org.codehaus.groovy.runtime.m12n.MetaInfExtensionModule;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
public class VertxExtensionModule extends ExtensionModule {
  private static final String extensionClasses = "io.vertx.groovy.ext.consul.ConsulClient_GroovyExtension, io.vertx.groovy.ext.consul.WatchResult_GroovyExtension";
  private static final String staticExtensionClasses = "io.vertx.groovy.ext.consul.ConsulClient_GroovyStaticExtension, io.vertx.groovy.ext.consul.Watch_GroovyStaticExtension";
  private final ExtensionModule delegate;  public VertxExtensionModule() {
    super("io.vertx.ext.consul", "3.5.0");
    Properties props = new Properties();
    props.put("moduleName", "io.vertx.ext.consul");
    props.put("moduleVersion", "3.5.0");
    props.put("extensionClasses", extensionClasses);
    props.put("staticExtensionClasses", staticExtensionClasses);
    delegate = MetaInfExtensionModule.newModule(props, getClass().getClassLoader());
  }
  public List<MetaMethod> getMetaMethods() {
    return delegate.getMetaMethods();
  }
}