/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.consul;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.rxjava.core.Vertx;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import java.util.List;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.CheckList;
import io.vertx.core.Handler;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.EventOptions;

/**
 * A Vert.x service used to interact with Consul.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.consul.ConsulClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.ext.consul.ConsulClient.class)
public class ConsulClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConsulClient that = (ConsulClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<ConsulClient> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new ConsulClient((io.vertx.ext.consul.ConsulClient) obj),
    ConsulClient::getDelegate
  );

  private final io.vertx.ext.consul.ConsulClient delegate;
  
  public ConsulClient(io.vertx.ext.consul.ConsulClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.ext.consul.ConsulClient getDelegate() {
    return delegate;
  }

  /**
   * Create a Consul client with default options.
   * @param vertx the Vert.x instance
   * @return the client
   */
  public static ConsulClient create(Vertx vertx) { 
    ConsulClient ret = ConsulClient.newInstance(io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a Consul client.
   * @param vertx the Vert.x instance
   * @param options the options
   * @return the client
   */
  public static ConsulClient create(Vertx vertx, ConsulClientOptions options) { 
    ConsulClient ret = ConsulClient.newInstance(io.vertx.ext.consul.ConsulClient.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Returns the configuration and member information of the local agent
   * @param resultHandler will be provided with the configuration and member information of the local agent
   * @return reference to this, for fluency
   */
  public ConsulClient agentInfo(Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.agentInfo(resultHandler);
    return this;
  }

  /**
   * Returns the configuration and member information of the local agent
   * @return 
   */
  public Single<JsonObject> rxAgentInfo() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      agentInfo(fut);
    }));
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @param resultHandler will be provided with network coordinates of nodes in datacenter
   * @return reference to this, for fluency
   */
  public ConsulClient coordinateNodes(Handler<AsyncResult<CoordinateList>> resultHandler) { 
    delegate.coordinateNodes(resultHandler);
    return this;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * @return 
   */
  public Single<CoordinateList> rxCoordinateNodes() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      coordinateNodes(fut);
    }));
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @param resultHandler will be provided with network coordinates of nodes in datacenter
   * @return reference to this, for fluency
   */
  public ConsulClient coordinateNodesWithOptions(BlockingQueryOptions options, Handler<AsyncResult<CoordinateList>> resultHandler) { 
    delegate.coordinateNodesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the LAN network coordinates for all nodes in a given DC
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#coordinateNodes}
   * @param options the blocking options
   * @return 
   */
  public Single<CoordinateList> rxCoordinateNodesWithOptions(BlockingQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      coordinateNodesWithOptions(options, fut);
    }));
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @param resultHandler will be provided with network coordinates for all Consul servers
   * @return reference to this, for fluency
   */
  public ConsulClient coordinateDatacenters(Handler<AsyncResult<List<DcCoordinates>>> resultHandler) { 
    delegate.coordinateDatacenters(resultHandler);
    return this;
  }

  /**
   * Returns the WAN network coordinates for all Consul servers, organized by DCs
   * @return 
   */
  public Single<List<DcCoordinates>> rxCoordinateDatacenters() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      coordinateDatacenters(fut);
    }));
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param resultHandler will be provided with keys list
   * @return reference to this, for fluency
   */
  public ConsulClient getKeys(String keyPrefix, Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getKeys(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @return 
   */
  public Single<List<String>> rxGetKeys(String keyPrefix) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getKeys(keyPrefix, fut);
    }));
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @param resultHandler will be provided with keys list
   * @return reference to this, for fluency
   */
  public ConsulClient getKeysWithOptions(String keyPrefix, BlockingQueryOptions options, Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getKeysWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  /**
   * Returns the list of keys that corresponding to the specified key prefix.
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return 
   */
  public Single<List<String>> rxGetKeysWithOptions(String keyPrefix, BlockingQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getKeysWithOptions(keyPrefix, options, fut);
    }));
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @param resultHandler will be provided with key/value pair
   * @return reference to this, for fluency
   */
  public ConsulClient getValue(String key, Handler<AsyncResult<KeyValue>> resultHandler) { 
    delegate.getValue(key, resultHandler);
    return this;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * @param key the key
   * @return 
   */
  public Single<KeyValue> rxGetValue(String key) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getValue(key, fut);
    }));
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @param resultHandler will be provided with key/value pair
   * @return reference to this, for fluency
   */
  public ConsulClient getValueWithOptions(String key, BlockingQueryOptions options, Handler<AsyncResult<KeyValue>> resultHandler) { 
    delegate.getValueWithOptions(key, options, resultHandler);
    return this;
  }

  /**
   * Returns key/value pair that corresponding to the specified key.
   * An empty {@link io.vertx.ext.consul.KeyValue} object will be returned if no such key is found.
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#getValue}
   * @param key the key
   * @param options the blocking options
   * @return 
   */
  public Single<KeyValue> rxGetValueWithOptions(String key, BlockingQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getValueWithOptions(key, options, fut);
    }));
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public ConsulClient deleteValue(String key, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deleteValue(key, resultHandler);
    return this;
  }

  /**
   * Remove the key/value pair that corresponding to the specified key
   * @param key the key
   * @return 
   */
  public Single<Void> rxDeleteValue(String key) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      deleteValue(key, fut);
    }));
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @param resultHandler will be provided with list of key/value pairs
   * @return reference to this, for fluency
   */
  public ConsulClient getValues(String keyPrefix, Handler<AsyncResult<KeyValueList>> resultHandler) { 
    delegate.getValues(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * @param keyPrefix the prefix
   * @return 
   */
  public Single<KeyValueList> rxGetValues(String keyPrefix) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getValues(keyPrefix, fut);
    }));
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @param resultHandler will be provided with list of key/value pairs
   * @return reference to this, for fluency
   */
  public ConsulClient getValuesWithOptions(String keyPrefix, BlockingQueryOptions options, Handler<AsyncResult<KeyValueList>> resultHandler) { 
    delegate.getValuesWithOptions(keyPrefix, options, resultHandler);
    return this;
  }

  /**
   * Returns the list of key/value pairs that corresponding to the specified key prefix.
   * An empty {@link io.vertx.ext.consul.KeyValueList} object will be returned if no such key prefix is found.
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#getValues}
   * @param keyPrefix the prefix
   * @param options the blocking options
   * @return 
   */
  public Single<KeyValueList> rxGetValuesWithOptions(String keyPrefix, BlockingQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getValuesWithOptions(keyPrefix, options, fut);
    }));
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public ConsulClient deleteValues(String keyPrefix, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deleteValues(keyPrefix, resultHandler);
    return this;
  }

  /**
   * Removes all the key/value pair that corresponding to the specified key prefix
   * @param keyPrefix the prefix
   * @return 
   */
  public Single<Void> rxDeleteValues(String keyPrefix) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      deleteValues(keyPrefix, fut);
    }));
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @param resultHandler will be provided with success of operation
   * @return reference to this, for fluency
   */
  public ConsulClient putValue(String key, String value, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.putValue(key, value, resultHandler);
    return this;
  }

  /**
   * Adds specified key/value pair
   * @param key the key
   * @param value the value
   * @return 
   */
  public Single<Boolean> rxPutValue(String key, String value) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      putValue(key, value, fut);
    }));
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @param resultHandler will be provided with success of operation
   * @return reference to this, for fluency
   */
  public ConsulClient putValueWithOptions(String key, String value, KeyValueOptions options, Handler<AsyncResult<Boolean>> resultHandler) { 
    delegate.putValueWithOptions(key, value, options, resultHandler);
    return this;
  }

  /**
   * @param key the key
   * @param value the value
   * @param options options used to push pair
   * @return 
   */
  public Single<Boolean> rxPutValueWithOptions(String key, String value, KeyValueOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      putValueWithOptions(key, value, options, fut);
    }));
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @param resultHandler will be provided with result of transaction
   * @return reference to this, for fluency
   */
  public ConsulClient transaction(TxnRequest request, Handler<AsyncResult<TxnResponse>> resultHandler) { 
    delegate.transaction(request, resultHandler);
    return this;
  }

  /**
   * Manages multiple operations inside a single, atomic transaction.
   * @param request transaction request
   * @return 
   */
  public Single<TxnResponse> rxTransaction(TxnRequest request) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      transaction(request, fut);
    }));
  }

  /**
   * Create new Acl token
   * @param token properties of the token
   * @param idHandler will be provided with ID of created token
   * @return reference to this, for fluency
   */
  public ConsulClient createAclToken(AclToken token, Handler<AsyncResult<String>> idHandler) { 
    delegate.createAclToken(token, idHandler);
    return this;
  }

  /**
   * Create new Acl token
   * @param token properties of the token
   * @return 
   */
  public Single<String> rxCreateAclToken(AclToken token) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createAclToken(token, fut);
    }));
  }

  /**
   * Update Acl token
   * @param token properties of the token to be updated
   * @param idHandler will be provided with ID of updated
   * @return reference to this, for fluency
   */
  public ConsulClient updateAclToken(AclToken token, Handler<AsyncResult<String>> idHandler) { 
    delegate.updateAclToken(token, idHandler);
    return this;
  }

  /**
   * Update Acl token
   * @param token properties of the token to be updated
   * @return 
   */
  public Single<String> rxUpdateAclToken(AclToken token) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      updateAclToken(token, fut);
    }));
  }

  /**
   * Clone Acl token
   * @param id the ID of token to be cloned
   * @param idHandler will be provided with ID of cloned token
   * @return reference to this, for fluency
   */
  public ConsulClient cloneAclToken(String id, Handler<AsyncResult<String>> idHandler) { 
    delegate.cloneAclToken(id, idHandler);
    return this;
  }

  /**
   * Clone Acl token
   * @param id the ID of token to be cloned
   * @return 
   */
  public Single<String> rxCloneAclToken(String id) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      cloneAclToken(id, fut);
    }));
  }

  /**
   * Get list of Acl token
   * @param resultHandler will be provided with list of tokens
   * @return reference to this, for fluency
   */
  public ConsulClient listAclTokens(Handler<AsyncResult<List<AclToken>>> resultHandler) { 
    delegate.listAclTokens(resultHandler);
    return this;
  }

  /**
   * Get list of Acl token
   * @return 
   */
  public Single<List<AclToken>> rxListAclTokens() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listAclTokens(fut);
    }));
  }

  /**
   * Get info of Acl token
   * @param id the ID of token
   * @param tokenHandler will be provided with token
   * @return reference to this, for fluency
   */
  public ConsulClient infoAclToken(String id, Handler<AsyncResult<AclToken>> tokenHandler) { 
    delegate.infoAclToken(id, tokenHandler);
    return this;
  }

  /**
   * Get info of Acl token
   * @param id the ID of token
   * @return 
   */
  public Single<AclToken> rxInfoAclToken(String id) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      infoAclToken(id, fut);
    }));
  }

  /**
   * Destroy Acl token
   * @param id the ID of token
   * @param resultHandler will be called on complete
   * @return reference to this, for fluency
   */
  public ConsulClient destroyAclToken(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.destroyAclToken(id, resultHandler);
    return this;
  }

  /**
   * Destroy Acl token
   * @param id the ID of token
   * @return 
   */
  public Single<Void> rxDestroyAclToken(String id) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      destroyAclToken(id, fut);
    }));
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param resultHandler will be provided with properties of event
   * @return reference to this, for fluency
   */
  public ConsulClient fireEvent(String name, Handler<AsyncResult<Event>> resultHandler) { 
    delegate.fireEvent(name, resultHandler);
    return this;
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @return 
   */
  public Single<Event> rxFireEvent(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      fireEvent(name, fut);
    }));
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @param resultHandler will be provided with properties of event
   * @return reference to this, for fluency
   */
  public ConsulClient fireEventWithOptions(String name, EventOptions options, Handler<AsyncResult<Event>> resultHandler) { 
    delegate.fireEventWithOptions(name, options, resultHandler);
    return this;
  }

  /**
   * Fires a new user event
   * @param name name of event
   * @param options options used to create event
   * @return 
   */
  public Single<Event> rxFireEventWithOptions(String name, EventOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      fireEventWithOptions(name, options, fut);
    }));
  }

  /**
   * Returns the most recent events known by the agent
   * @param resultHandler will be provided with list of events
   * @return reference to this, for fluency
   */
  public ConsulClient listEvents(Handler<AsyncResult<EventList>> resultHandler) { 
    delegate.listEvents(resultHandler);
    return this;
  }

  /**
   * Returns the most recent events known by the agent
   * @return 
   */
  public Single<EventList> rxListEvents() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listEvents(fut);
    }));
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @param resultHandler will be provided with list of events
   * @return reference to this, for fluency
   */
  public ConsulClient listEventsWithOptions(EventListOptions options, Handler<AsyncResult<EventList>> resultHandler) { 
    delegate.listEventsWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the most recent events known by the agent.
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#listEvents}. However, the semantics of this endpoint
   * are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   * This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   * there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   * <p>
   * In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   * Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.
   * @param options the blocking options
   * @return 
   */
  public Single<EventList> rxListEventsWithOptions(EventListOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listEventsWithOptions(options, fut);
    }));
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient registerService(ServiceOptions serviceOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.registerService(serviceOptions, resultHandler);
    return this;
  }

  /**
   * Adds a new service, with an optional health check, to the local agent.
   * @param serviceOptions the options of new service
   * @return 
   */
  public Single<Void> rxRegisterService(ServiceOptions serviceOptions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      registerService(serviceOptions, fut);
    }));
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient maintenanceService(MaintenanceOptions maintenanceOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.maintenanceService(maintenanceOptions, resultHandler);
    return this;
  }

  /**
   * Places a given service into "maintenance mode"
   * @param maintenanceOptions the maintenance options
   * @return 
   */
  public Single<Void> rxMaintenanceService(MaintenanceOptions maintenanceOptions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      maintenanceService(maintenanceOptions, fut);
    }));
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient deregisterService(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deregisterService(id, resultHandler);
    return this;
  }

  /**
   * Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   * If there is an associated check, that is also deregistered.
   * @param id the ID of service
   * @return 
   */
  public Single<Void> rxDeregisterService(String id) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      deregisterService(id, fut);
    }));
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param resultHandler will be provided with list of nodes providing given service
   * @return reference to this, for fluency
   */
  public ConsulClient catalogServiceNodes(String service, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServiceNodes(service, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @return 
   */
  public Single<ServiceList> rxCatalogServiceNodes(String service) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      catalogServiceNodes(service, fut);
    }));
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @param resultHandler will be provided with list of nodes providing given service
   * @return reference to this, for fluency
   */
  public ConsulClient catalogServiceNodesWithOptions(String service, ServiceQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServiceNodesWithOptions(service, options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing a service
   * @param service name of service
   * @param options options used to request services
   * @return 
   */
  public Single<ServiceList> rxCatalogServiceNodesWithOptions(String service, ServiceQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      catalogServiceNodesWithOptions(service, options, fut);
    }));
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @param resultHandler will be provided with list of datacenters
   * @return reference to this, for fluency
   */
  public ConsulClient catalogDatacenters(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.catalogDatacenters(resultHandler);
    return this;
  }

  /**
   * Return all the datacenters that are known by the Consul server
   * @return 
   */
  public Single<List<String>> rxCatalogDatacenters() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      catalogDatacenters(fut);
    }));
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param resultHandler will be provided with list of nodes
   * @return reference to this, for fluency
   */
  public ConsulClient catalogNodes(Handler<AsyncResult<NodeList>> resultHandler) { 
    delegate.catalogNodes(resultHandler);
    return this;
  }

  /**
   * Returns the nodes registered in a datacenter
   * @return 
   */
  public Single<NodeList> rxCatalogNodes() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      catalogNodes(fut);
    }));
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @param resultHandler will be provided with list of nodes
   * @return reference to this, for fluency
   */
  public ConsulClient catalogNodesWithOptions(NodeQueryOptions options, Handler<AsyncResult<NodeList>> resultHandler) { 
    delegate.catalogNodesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes registered in a datacenter
   * @param options options used to request nodes
   * @return 
   */
  public Single<NodeList> rxCatalogNodesWithOptions(NodeQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      catalogNodesWithOptions(options, fut);
    }));
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public ConsulClient healthChecks(String service, Handler<AsyncResult<CheckList>> resultHandler) { 
    delegate.healthChecks(service, resultHandler);
    return this;
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @return 
   */
  public Single<CheckList> rxHealthChecks(String service) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      healthChecks(service, fut);
    }));
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public ConsulClient healthChecksWithOptions(String service, CheckQueryOptions options, Handler<AsyncResult<CheckList>> resultHandler) { 
    delegate.healthChecksWithOptions(service, options, resultHandler);
    return this;
  }

  /**
   * Returns the checks associated with the service
   * @param service the service name
   * @param options options used to request checks
   * @return 
   */
  public Single<CheckList> rxHealthChecksWithOptions(String service, CheckQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      healthChecksWithOptions(service, options, fut);
    }));
  }

  /**
   * Returns the checks in the specified status
   * @param checkStatus the check status
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public ConsulClient healthState(CheckStatus checkStatus, Handler<AsyncResult<CheckList>> resultHandler) { 
    delegate.healthState(checkStatus, resultHandler);
    return this;
  }

  /**
   * Returns the checks in the specified status
   * @param checkStatus the check status
   * @return 
   */
  public Single<CheckList> rxHealthState(CheckStatus checkStatus) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      healthState(checkStatus, fut);
    }));
  }

  /**
   * Returns the checks in the specified status
   * @param checkStatus the check status
   * @param options options used to request checks
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public ConsulClient healthStateWithOptions(CheckStatus checkStatus, CheckQueryOptions options, Handler<AsyncResult<CheckList>> resultHandler) { 
    delegate.healthStateWithOptions(checkStatus, options, resultHandler);
    return this;
  }

  /**
   * Returns the checks in the specified status
   * @param checkStatus the check status
   * @param options options used to request checks
   * @return 
   */
  public Single<CheckList> rxHealthStateWithOptions(CheckStatus checkStatus, CheckQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      healthStateWithOptions(checkStatus, options, fut);
    }));
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.rxjava.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public ConsulClient healthServiceNodes(String service, boolean passing, Handler<AsyncResult<ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodes(service, passing, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.rxjava.ext.consul.ConsulClient#catalogServiceNodes} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @return 
   */
  public Single<ServiceEntryList> rxHealthServiceNodes(String service, boolean passing) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      healthServiceNodes(service, passing, fut);
    }));
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.rxjava.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public ConsulClient healthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options, Handler<AsyncResult<ServiceEntryList>> resultHandler) { 
    delegate.healthServiceNodesWithOptions(service, passing, options, resultHandler);
    return this;
  }

  /**
   * Returns the nodes providing the service. This endpoint is very similar to the {@link io.vertx.rxjava.ext.consul.ConsulClient#catalogServiceNodesWithOptions} endpoint;
   * however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.
   * @param service the service name
   * @param passing if true, filter results to only nodes with all checks in the passing state
   * @param options options used to request services
   * @return 
   */
  public Single<ServiceEntryList> rxHealthServiceNodesWithOptions(String service, boolean passing, ServiceQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      healthServiceNodesWithOptions(service, passing, options, fut);
    }));
  }

  /**
   * Returns the services registered in a datacenter
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public ConsulClient catalogServices(Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServices(resultHandler);
    return this;
  }

  /**
   * Returns the services registered in a datacenter
   * @return 
   */
  public Single<ServiceList> rxCatalogServices() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      catalogServices(fut);
    }));
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public ConsulClient catalogServicesWithOptions(BlockingQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogServicesWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the services registered in a datacenter
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#catalogServices}
   * @param options the blocking options
   * @return 
   */
  public Single<ServiceList> rxCatalogServicesWithOptions(BlockingQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      catalogServicesWithOptions(options, fut);
    }));
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public ConsulClient catalogNodeServices(String node, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogNodeServices(node, resultHandler);
    return this;
  }

  /**
   * Returns the node's registered services
   * @param node node name
   * @return 
   */
  public Single<ServiceList> rxCatalogNodeServices(String node) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      catalogNodeServices(node, fut);
    }));
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public ConsulClient catalogNodeServicesWithOptions(String node, BlockingQueryOptions options, Handler<AsyncResult<ServiceList>> resultHandler) { 
    delegate.catalogNodeServicesWithOptions(node, options, resultHandler);
    return this;
  }

  /**
   * Returns the node's registered services
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#catalogNodeServices}
   * @param node node name
   * @param options the blocking options
   * @return 
   */
  public Single<ServiceList> rxCatalogNodeServicesWithOptions(String node, BlockingQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      catalogNodeServicesWithOptions(node, options, fut);
    }));
  }

  /**
   * Returns list of services registered with the local agent.
   * @param resultHandler will be provided with list of services
   * @return reference to this, for fluency
   */
  public ConsulClient localServices(Handler<AsyncResult<List<Service>>> resultHandler) { 
    delegate.localServices(resultHandler);
    return this;
  }

  /**
   * Returns list of services registered with the local agent.
   * @return 
   */
  public Single<List<Service>> rxLocalServices() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      localServices(fut);
    }));
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @param resultHandler will be provided with list of checks
   * @return reference to this, for fluency
   */
  public ConsulClient localChecks(Handler<AsyncResult<List<Check>>> resultHandler) { 
    delegate.localChecks(resultHandler);
    return this;
  }

  /**
   * Return all the checks that are registered with the local agent.
   * @return 
   */
  public Single<List<Check>> rxLocalChecks() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      localChecks(fut);
    }));
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient registerCheck(CheckOptions checkOptions, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.registerCheck(checkOptions, resultHandler);
    return this;
  }

  /**
   * Add a new check to the local agent. The agent is responsible for managing the status of the check
   * and keeping the Catalog in sync.
   * @param checkOptions options used to register new check
   * @return 
   */
  public Single<Void> rxRegisterCheck(CheckOptions checkOptions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      registerCheck(checkOptions, fut);
    }));
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient deregisterCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deregisterCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.
   * @param checkId the ID of check
   * @return 
   */
  public Single<Void> rxDeregisterCheck(String checkId) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      deregisterCheck(checkId, fut);
    }));
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient passCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.passCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return 
   */
  public Single<Void> rxPassCheck(String checkId) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      passCheck(checkId, fut);
    }));
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note a human-readable message with the status of the check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient passCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.passCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note a human-readable message with the status of the check
   * @return 
   */
  public Single<Void> rxPassCheckWithNote(String checkId, String note) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      passCheckWithNote(checkId, note, fut);
    }));
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient warnCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.warnCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return 
   */
  public Single<Void> rxWarnCheck(String checkId) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      warnCheck(checkId, fut);
    }));
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note a human-readable message with the status of the check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient warnCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.warnCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note a human-readable message with the status of the check
   * @return 
   */
  public Single<Void> rxWarnCheckWithNote(String checkId, String note) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      warnCheckWithNote(checkId, note, fut);
    }));
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient failCheck(String checkId, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.failCheck(checkId, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @return 
   */
  public Single<Void> rxFailCheck(String checkId) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      failCheck(checkId, fut);
    }));
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note a human-readable message with the status of the check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient failCheckWithNote(String checkId, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.failCheckWithNote(checkId, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param note a human-readable message with the status of the check
   * @return 
   */
  public Single<Void> rxFailCheckWithNote(String checkId, String note) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      failCheckWithNote(checkId, note, fut);
    }));
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient updateCheck(String checkId, CheckStatus status, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateCheck(checkId, status, resultHandler);
    return this;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @return 
   */
  public Single<Void> rxUpdateCheck(String checkId, CheckStatus status) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      updateCheck(checkId, status, fut);
    }));
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note a human-readable message with the status of the check
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient updateCheckWithNote(String checkId, CheckStatus status, String note, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateCheckWithNote(checkId, status, note, resultHandler);
    return this;
  }

  /**
   * Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.
   * @param checkId the ID of check
   * @param status new status of check
   * @param note a human-readable message with the status of the check
   * @return 
   */
  public Single<Void> rxUpdateCheckWithNote(String checkId, CheckStatus status, String note) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      updateCheckWithNote(checkId, status, note, fut);
    }));
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @param resultHandler will be provided with address of cluster leader
   * @return reference to this, for fluency
   */
  public ConsulClient leaderStatus(Handler<AsyncResult<String>> resultHandler) { 
    delegate.leaderStatus(resultHandler);
    return this;
  }

  /**
   * Get the Raft leader for the datacenter in which the agent is running.
   * It returns an address in format "<code>10.1.10.12:8300</code>"
   * @return 
   */
  public Single<String> rxLeaderStatus() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      leaderStatus(fut);
    }));
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @param resultHandler will be provided with list of peers
   * @return reference to this, for fluency
   */
  public ConsulClient peersStatus(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.peersStatus(resultHandler);
    return this;
  }

  /**
   * Retrieves the Raft peers for the datacenter in which the the agent is running.
   * It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"
   * @return 
   */
  public Single<List<String>> rxPeersStatus() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      peersStatus(fut);
    }));
  }

  /**
   * Initialize a new session
   * @param idHandler will be provided with ID of new session
   * @return reference to this, for fluency
   */
  public ConsulClient createSession(Handler<AsyncResult<String>> idHandler) { 
    delegate.createSession(idHandler);
    return this;
  }

  /**
   * Initialize a new session
   * @return 
   */
  public Single<String> rxCreateSession() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createSession(fut);
    }));
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @param idHandler will be provided with ID of new session
   * @return reference to this, for fluency
   */
  public ConsulClient createSessionWithOptions(SessionOptions options, Handler<AsyncResult<String>> idHandler) { 
    delegate.createSessionWithOptions(options, idHandler);
    return this;
  }

  /**
   * Initialize a new session
   * @param options options used to create session
   * @return 
   */
  public Single<String> rxCreateSessionWithOptions(SessionOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createSessionWithOptions(options, fut);
    }));
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @param resultHandler will be provided with info of requested session
   * @return reference to this, for fluency
   */
  public ConsulClient infoSession(String id, Handler<AsyncResult<Session>> resultHandler) { 
    delegate.infoSession(id, resultHandler);
    return this;
  }

  /**
   * Returns the requested session information
   * @param id the ID of requested session
   * @return 
   */
  public Single<Session> rxInfoSession(String id) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      infoSession(id, fut);
    }));
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @param resultHandler will be provided with info of requested session
   * @return reference to this, for fluency
   */
  public ConsulClient infoSessionWithOptions(String id, BlockingQueryOptions options, Handler<AsyncResult<Session>> resultHandler) { 
    delegate.infoSessionWithOptions(id, options, resultHandler);
    return this;
  }

  /**
   * Returns the requested session information
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#infoSession}
   * @param id the ID of requested session
   * @param options the blocking options
   * @return 
   */
  public Single<Session> rxInfoSessionWithOptions(String id, BlockingQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      infoSessionWithOptions(id, options, fut);
    }));
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @param resultHandler will be provided with info of renewed session
   * @return reference to this, for fluency
   */
  public ConsulClient renewSession(String id, Handler<AsyncResult<Session>> resultHandler) { 
    delegate.renewSession(id, resultHandler);
    return this;
  }

  /**
   * Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL
   * @param id the ID of session that should be renewed
   * @return 
   */
  public Single<Session> rxRenewSession(String id) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      renewSession(id, fut);
    }));
  }

  /**
   * Returns the active sessions
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public ConsulClient listSessions(Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listSessions(resultHandler);
    return this;
  }

  /**
   * Returns the active sessions
   * @return 
   */
  public Single<SessionList> rxListSessions() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listSessions(fut);
    }));
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public ConsulClient listSessionsWithOptions(BlockingQueryOptions options, Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listSessionsWithOptions(options, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#listSessions}
   * @param options the blocking options
   * @return 
   */
  public Single<SessionList> rxListSessionsWithOptions(BlockingQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listSessionsWithOptions(options, fut);
    }));
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public ConsulClient listNodeSessions(String nodeId, Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listNodeSessions(nodeId, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions for a given node
   * @param nodeId the ID of node
   * @return 
   */
  public Single<SessionList> rxListNodeSessions(String nodeId) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listNodeSessions(nodeId, fut);
    }));
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @param resultHandler will be provided with list of sessions
   * @return reference to this, for fluency
   */
  public ConsulClient listNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options, Handler<AsyncResult<SessionList>> resultHandler) { 
    delegate.listNodeSessionsWithOptions(nodeId, options, resultHandler);
    return this;
  }

  /**
   * Returns the active sessions for a given node
   * This is blocking query unlike {@link io.vertx.rxjava.ext.consul.ConsulClient#listNodeSessions}
   * @param nodeId the ID of node
   * @param options the blocking options
   * @return 
   */
  public Single<SessionList> rxListNodeSessionsWithOptions(String nodeId, BlockingQueryOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listNodeSessionsWithOptions(nodeId, options, fut);
    }));
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient destroySession(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.destroySession(id, resultHandler);
    return this;
  }

  /**
   * Destroys the given session
   * @param id the ID of session
   * @return 
   */
  public Single<Void> rxDestroySession(String id) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      destroySession(id, fut);
    }));
  }

  /**
   * @param definition definition of the prepare query
   * @param resultHandler will be provided with id of created prepare query
   * @return reference to this, for fluency
   */
  public ConsulClient createPreparedQuery(PreparedQueryDefinition definition, Handler<AsyncResult<String>> resultHandler) { 
    delegate.createPreparedQuery(definition, resultHandler);
    return this;
  }

  /**
   * @param definition definition of the prepare query
   * @return 
   */
  public Single<String> rxCreatePreparedQuery(PreparedQueryDefinition definition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      createPreparedQuery(definition, fut);
    }));
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @param resultHandler will be provided with definition of the prepare query
   * @return reference to this, for fluency
   */
  public ConsulClient getPreparedQuery(String id, Handler<AsyncResult<PreparedQueryDefinition>> resultHandler) { 
    delegate.getPreparedQuery(id, resultHandler);
    return this;
  }

  /**
   * Returns an existing prepared query
   * @param id the id of the query to read
   * @return 
   */
  public Single<PreparedQueryDefinition> rxGetPreparedQuery(String id) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getPreparedQuery(id, fut);
    }));
  }

  /**
   * Returns a list of all prepared queries.
   * @param resultHandler will be provided with list of definitions of the all prepare queries
   * @return reference to this, for fluency
   */
  public ConsulClient getAllPreparedQueries(Handler<AsyncResult<List<PreparedQueryDefinition>>> resultHandler) { 
    delegate.getAllPreparedQueries(resultHandler);
    return this;
  }

  /**
   * Returns a list of all prepared queries.
   * @return 
   */
  public Single<List<PreparedQueryDefinition>> rxGetAllPreparedQueries() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getAllPreparedQueries(fut);
    }));
  }

  /**
   * @param definition definition of the prepare query
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient updatePreparedQuery(PreparedQueryDefinition definition, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updatePreparedQuery(definition, resultHandler);
    return this;
  }

  /**
   * @param definition definition of the prepare query
   * @return 
   */
  public Single<Void> rxUpdatePreparedQuery(PreparedQueryDefinition definition) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      updatePreparedQuery(definition, fut);
    }));
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @param resultHandler will be called when complete
   * @return reference to this, for fluency
   */
  public ConsulClient deletePreparedQuery(String id, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.deletePreparedQuery(id, resultHandler);
    return this;
  }

  /**
   * Deletes an existing prepared query
   * @param id the id of the query to delete
   * @return 
   */
  public Single<Void> rxDeletePreparedQuery(String id) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      deletePreparedQuery(id, fut);
    }));
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param resultHandler will be provided with response
   * @return reference to this, for fluency
   */
  public ConsulClient executePreparedQuery(String query, Handler<AsyncResult<PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQuery(query, resultHandler);
    return this;
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @return 
   */
  public Single<PreparedQueryExecuteResponse> rxExecutePreparedQuery(String query) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      executePreparedQuery(query, fut);
    }));
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @param resultHandler will be provided with response
   * @return reference to this, for fluency
   */
  public ConsulClient executePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options, Handler<AsyncResult<PreparedQueryExecuteResponse>> resultHandler) { 
    delegate.executePreparedQueryWithOptions(query, options, resultHandler);
    return this;
  }

  /**
   * Executes an existing prepared query.
   * @param query the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template.
   * @param options the options used to execute prepared query
   * @return 
   */
  public Single<PreparedQueryExecuteResponse> rxExecutePreparedQueryWithOptions(String query, PreparedQueryExecuteOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      executePreparedQueryWithOptions(query, options, fut);
    }));
  }

  /**
   * Close the client and release its resources
   */
  public void close() { 
    delegate.close();
  }


  public static  ConsulClient newInstance(io.vertx.ext.consul.ConsulClient arg) {
    return arg != null ? new ConsulClient(arg) : null;
  }
}
