/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.consul;

import java.util.Map;
import rx.Observable;
import rx.Single;


@io.vertx.lang.rxjava.RxGen(io.vertx.ext.consul.WatchResult.class)
public class WatchResult<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WatchResult that = (WatchResult) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<WatchResult> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new WatchResult((io.vertx.ext.consul.WatchResult) obj),
    WatchResult::getDelegate
  );

  private final io.vertx.ext.consul.WatchResult delegate;
  public final io.vertx.lang.rxjava.TypeArg<T> __typeArg_0;
  
  public WatchResult(io.vertx.ext.consul.WatchResult delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rxjava.TypeArg.unknown();
  }

  public WatchResult(io.vertx.ext.consul.WatchResult delegate, io.vertx.lang.rxjava.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.ext.consul.WatchResult getDelegate() {
    return delegate;
  }

  /**
   * The previous result of the operation.
   * @return the previous result.
   */
  public T prevResult() { 
    T ret = (T)__typeArg_0.wrap(delegate.prevResult());
    return ret;
  }

  /**
   * The next result of the operation. This will be null if the operation failed.
   * @return the next result or null if the operation failed.
   */
  public T nextResult() { 
    T ret = (T)__typeArg_0.wrap(delegate.nextResult());
    return ret;
  }

  /**
   * A Throwable describing failure. This will be null if the operation succeeded.
   * @return the cause or null if the operation succeeded.
   */
  public Throwable cause() { 
    Throwable ret = delegate.cause();
    return ret;
  }

  /**
   * Did it succeed?
   * @return true if it succeded or false otherwise
   */
  public boolean succeeded() { 
    boolean ret = delegate.succeeded();
    return ret;
  }

  /**
   * Did it fail?
   * @return true if it failed or false otherwise
   */
  public boolean failed() { 
    boolean ret = delegate.failed();
    return ret;
  }


  public static <T>WatchResult<T> newInstance(io.vertx.ext.consul.WatchResult arg) {
    return arg != null ? new WatchResult<T>(arg) : null;
  }

  public static <T>WatchResult<T> newInstance(io.vertx.ext.consul.WatchResult arg, io.vertx.lang.rxjava.TypeArg<T> __typeArg_T) {
    return arg != null ? new WatchResult<T>(arg, __typeArg_T) : null;
  }
}
