/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Http2Settings;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.consul.ConsulClientOptionsConverter;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.List;

@DataObject(generateConverter=true)
public class ConsulClientOptions
extends WebClientOptions {
    private static final String CONSUL_DEFAULT_HOST = "localhost";
    private static final int CONSUL_DEFAULT_PORT = 8500;
    private String aclToken;
    private String dc;
    private long timeoutMs;

    public ConsulClientOptions() {
        this.setDefaultHost(CONSUL_DEFAULT_HOST);
        this.setDefaultPort(8500);
    }

    public ConsulClientOptions(ConsulClientOptions options) {
        super((WebClientOptions)options);
        this.setHost(options.getHost());
        this.setPort(options.getPort());
        this.setAclToken(options.getAclToken());
        this.setDc(options.getDc());
        this.setTimeout(options.getTimeout());
    }

    public ConsulClientOptions(JsonObject json) {
        super(json);
        ConsulClientOptionsConverter.fromJson(json, this);
        if (json.getValue("host") instanceof String) {
            this.setHost((String)json.getValue("host"));
        } else {
            this.setHost(CONSUL_DEFAULT_HOST);
        }
        if (json.getValue("port") instanceof Number) {
            this.setPort(((Number)json.getValue("port")).intValue());
        } else {
            this.setPort(8500);
        }
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        ConsulClientOptionsConverter.toJson(this, json);
        if (this.getHost() != null) {
            json.put("host", this.getHost());
        }
        json.put("port", Integer.valueOf(this.getPort()));
        return json;
    }

    @GenIgnore
    public String getHost() {
        return this.getDefaultHost();
    }

    @GenIgnore
    public int getPort() {
        return this.getDefaultPort();
    }

    public String getAclToken() {
        return this.aclToken;
    }

    public String getDc() {
        return this.dc;
    }

    public long getTimeout() {
        return this.timeoutMs;
    }

    @GenIgnore
    public ConsulClientOptions setHost(String host) {
        this.setDefaultHost(host);
        return this;
    }

    @GenIgnore
    public ConsulClientOptions setPort(int port) {
        this.setDefaultPort(port);
        return this;
    }

    public ConsulClientOptions setAclToken(String aclToken) {
        this.aclToken = aclToken;
        return this;
    }

    public ConsulClientOptions setDc(String dc) {
        this.dc = dc;
        return this;
    }

    public ConsulClientOptions setTimeout(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        return this;
    }

    public ConsulClientOptions setSendBufferSize(int sendBufferSize) {
        return (ConsulClientOptions)super.setSendBufferSize(sendBufferSize);
    }

    public ConsulClientOptions setReceiveBufferSize(int receiveBufferSize) {
        return (ConsulClientOptions)super.setReceiveBufferSize(receiveBufferSize);
    }

    public ConsulClientOptions setReuseAddress(boolean reuseAddress) {
        return (ConsulClientOptions)super.setReuseAddress(reuseAddress);
    }

    public ConsulClientOptions setReusePort(boolean reusePort) {
        return (ConsulClientOptions)super.setReusePort(reusePort);
    }

    public ConsulClientOptions setTrafficClass(int trafficClass) {
        return (ConsulClientOptions)super.setTrafficClass(trafficClass);
    }

    public ConsulClientOptions setTcpNoDelay(boolean tcpNoDelay) {
        return (ConsulClientOptions)super.setTcpNoDelay(tcpNoDelay);
    }

    public ConsulClientOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        return (ConsulClientOptions)super.setTcpKeepAlive(tcpKeepAlive);
    }

    public ConsulClientOptions setTcpCork(boolean tcpCork) {
        return (ConsulClientOptions)super.setTcpCork(tcpCork);
    }

    public ConsulClientOptions setTcpQuickAck(boolean tcpQuickAck) {
        return (ConsulClientOptions)super.setTcpQuickAck(tcpQuickAck);
    }

    public ConsulClientOptions setTcpFastOpen(boolean tcpFastOpen) {
        return (ConsulClientOptions)super.setTcpFastOpen(tcpFastOpen);
    }

    public ConsulClientOptions setSoLinger(int soLinger) {
        return (ConsulClientOptions)super.setSoLinger(soLinger);
    }

    public ConsulClientOptions setUsePooledBuffers(boolean usePooledBuffers) {
        return (ConsulClientOptions)super.setUsePooledBuffers(usePooledBuffers);
    }

    public ConsulClientOptions setIdleTimeout(int idleTimeout) {
        return (ConsulClientOptions)super.setIdleTimeout(idleTimeout);
    }

    public ConsulClientOptions setSsl(boolean ssl) {
        super.setSsl(ssl);
        return this;
    }

    public ConsulClientOptions setKeyCertOptions(KeyCertOptions options) {
        return (ConsulClientOptions)super.setKeyCertOptions(options);
    }

    public ConsulClientOptions setKeyStoreOptions(JksOptions options) {
        return (ConsulClientOptions)super.setKeyStoreOptions(options);
    }

    public ConsulClientOptions setPfxKeyCertOptions(PfxOptions options) {
        return (ConsulClientOptions)super.setPfxKeyCertOptions(options);
    }

    public ConsulClientOptions setTrustOptions(TrustOptions options) {
        return (ConsulClientOptions)super.setTrustOptions(options);
    }

    public ConsulClientOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (ConsulClientOptions)super.setPemKeyCertOptions(options);
    }

    public ConsulClientOptions setTrustStoreOptions(JksOptions options) {
        return (ConsulClientOptions)super.setTrustStoreOptions(options);
    }

    public ConsulClientOptions setPfxTrustOptions(PfxOptions options) {
        return (ConsulClientOptions)super.setPfxTrustOptions(options);
    }

    public ConsulClientOptions setTrustAll(boolean trustAll) {
        super.setTrustAll(trustAll);
        return this;
    }

    public ConsulClientOptions setPemTrustOptions(PemTrustOptions pemTrustOptions) {
        super.setPemTrustOptions(pemTrustOptions);
        return this;
    }

    public ConsulClientOptions setConnectTimeout(int connectTimeout) {
        return (ConsulClientOptions)super.setConnectTimeout(connectTimeout);
    }

    public ConsulClientOptions setMaxPoolSize(int maxPoolSize) {
        return (ConsulClientOptions)super.setMaxPoolSize(maxPoolSize);
    }

    public ConsulClientOptions setHttp2MultiplexingLimit(int limit) {
        return (ConsulClientOptions)super.setHttp2MultiplexingLimit(limit);
    }

    public ConsulClientOptions setHttp2MaxPoolSize(int max) {
        return (ConsulClientOptions)super.setHttp2MaxPoolSize(max);
    }

    public ConsulClientOptions setHttp2ConnectionWindowSize(int http2ConnectionWindowSize) {
        return (ConsulClientOptions)super.setHttp2ConnectionWindowSize(http2ConnectionWindowSize);
    }

    public ConsulClientOptions setKeepAlive(boolean keepAlive) {
        return (ConsulClientOptions)super.setKeepAlive(keepAlive);
    }

    public ConsulClientOptions setPipelining(boolean pipelining) {
        return (ConsulClientOptions)super.setPipelining(pipelining);
    }

    public ConsulClientOptions setPipeliningLimit(int limit) {
        return (ConsulClientOptions)super.setPipeliningLimit(limit);
    }

    public ConsulClientOptions setVerifyHost(boolean verifyHost) {
        return (ConsulClientOptions)super.setVerifyHost(verifyHost);
    }

    public ConsulClientOptions setTryUseCompression(boolean tryUseCompression) {
        return (ConsulClientOptions)super.setTryUseCompression(tryUseCompression);
    }

    public ConsulClientOptions setSendUnmaskedFrames(boolean sendUnmaskedFrames) {
        return (ConsulClientOptions)super.setSendUnmaskedFrames(sendUnmaskedFrames);
    }

    public ConsulClientOptions setMaxWebsocketFrameSize(int maxWebsocketFrameSize) {
        return (ConsulClientOptions)super.setMaxWebsocketFrameSize(maxWebsocketFrameSize);
    }

    public ConsulClientOptions setDefaultHost(String defaultHost) {
        return (ConsulClientOptions)super.setDefaultHost(defaultHost);
    }

    public ConsulClientOptions setDefaultPort(int defaultPort) {
        return (ConsulClientOptions)super.setDefaultPort(defaultPort);
    }

    public ConsulClientOptions setProtocolVersion(HttpVersion protocolVersion) {
        return (ConsulClientOptions)super.setProtocolVersion(protocolVersion);
    }

    public ConsulClientOptions setMaxChunkSize(int maxChunkSize) {
        return (ConsulClientOptions)super.setMaxChunkSize(maxChunkSize);
    }

    public ConsulClientOptions setMaxInitialLineLength(int maxInitialLineLength) {
        return (ConsulClientOptions)super.setMaxInitialLineLength(maxInitialLineLength);
    }

    public ConsulClientOptions setMaxHeaderSize(int maxHeaderSize) {
        return (ConsulClientOptions)super.setMaxHeaderSize(maxHeaderSize);
    }

    public ConsulClientOptions setMaxWaitQueueSize(int maxWaitQueueSize) {
        return (ConsulClientOptions)super.setMaxWaitQueueSize(maxWaitQueueSize);
    }

    public ConsulClientOptions setInitialSettings(Http2Settings settings) {
        return (ConsulClientOptions)super.setInitialSettings(settings);
    }

    public ConsulClientOptions setUseAlpn(boolean useAlpn) {
        return (ConsulClientOptions)super.setUseAlpn(useAlpn);
    }

    public ConsulClientOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return (ConsulClientOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    public ConsulClientOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (ConsulClientOptions)super.setJdkSslEngineOptions(sslEngineOptions);
    }

    public ConsulClientOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return (ConsulClientOptions)super.setOpenSslEngineOptions(sslEngineOptions);
    }

    public ConsulClientOptions setAlpnVersions(List<HttpVersion> alpnVersions) {
        return (ConsulClientOptions)super.setAlpnVersions(alpnVersions);
    }

    public ConsulClientOptions setHttp2ClearTextUpgrade(boolean value) {
        return (ConsulClientOptions)super.setHttp2ClearTextUpgrade(value);
    }

    public ConsulClientOptions setMaxRedirects(int maxRedirects) {
        return (ConsulClientOptions)super.setMaxRedirects(maxRedirects);
    }

    public ConsulClientOptions setMetricsName(String metricsName) {
        return (ConsulClientOptions)super.setMetricsName(metricsName);
    }

    public ConsulClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        return (ConsulClientOptions)super.setProxyOptions(proxyOptions);
    }

    public ConsulClientOptions setLocalAddress(String localAddress) {
        return (ConsulClientOptions)super.setLocalAddress(localAddress);
    }

    public ConsulClientOptions setLogActivity(boolean logActivity) {
        return (ConsulClientOptions)super.setLogActivity(logActivity);
    }

    public ConsulClientOptions setUserAgentEnabled(boolean userAgentEnabled) {
        return (ConsulClientOptions)super.setUserAgentEnabled(userAgentEnabled);
    }

    public ConsulClientOptions setUserAgent(String userAgent) {
        return (ConsulClientOptions)super.setUserAgent(userAgent);
    }

    public ConsulClientOptions setFollowRedirects(boolean followRedirects) {
        return (ConsulClientOptions)super.setFollowRedirects(followRedirects);
    }

    public ConsulClientOptions setMaxWebsocketMessageSize(int maxWebsocketMessageSize) {
        return (ConsulClientOptions)super.setMaxWebsocketMessageSize(maxWebsocketMessageSize);
    }

    public ConsulClientOptions addEnabledCipherSuite(String suite) {
        return (ConsulClientOptions)super.addEnabledCipherSuite(suite);
    }

    public ConsulClientOptions addEnabledSecureTransportProtocol(String protocol) {
        return (ConsulClientOptions)super.addEnabledSecureTransportProtocol(protocol);
    }

    public ConsulClientOptions addCrlPath(String crlPath) throws NullPointerException {
        return (ConsulClientOptions)super.addCrlPath(crlPath);
    }

    public ConsulClientOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (ConsulClientOptions)super.addCrlValue(crlValue);
    }

    public ConsulClientOptions setForceSni(boolean forceSni) {
        return (ConsulClientOptions)super.setForceSni(forceSni);
    }

    public ConsulClientOptions setDecoderInitialBufferSize(int decoderInitialBufferSize) {
        return (ConsulClientOptions)super.setDecoderInitialBufferSize(decoderInitialBufferSize);
    }
}

