/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Coordinate;
import java.util.ArrayList;

public class CoordinateConverter {
    public static void fromJson(JsonObject json, Coordinate obj) {
        if (json.getValue("adj") instanceof Number) {
            obj.setAdj(((Number)json.getValue("adj")).floatValue());
        }
        if (json.getValue("err") instanceof Number) {
            obj.setErr(((Number)json.getValue("err")).floatValue());
        }
        if (json.getValue("height") instanceof Number) {
            obj.setHeight(((Number)json.getValue("height")).floatValue());
        }
        if (json.getValue("node") instanceof String) {
            obj.setNode((String)json.getValue("node"));
        }
        if (json.getValue("vec") instanceof JsonArray) {
            ArrayList<Float> list = new ArrayList<Float>();
            json.getJsonArray("vec").forEach(item -> {
                if (item instanceof Number) {
                    list.add(Float.valueOf(((Number)item).floatValue()));
                }
            });
            obj.setVec(list);
        }
    }

    public static void toJson(Coordinate obj, JsonObject json) {
        json.put("adj", Float.valueOf(obj.getAdj()));
        json.put("err", Float.valueOf(obj.getErr()));
        json.put("height", Float.valueOf(obj.getHeight()));
        if (obj.getNode() != null) {
            json.put("node", obj.getNode());
        }
        if (obj.getVec() != null) {
            JsonArray array = new JsonArray();
            obj.getVec().forEach(item -> array.add(item));
            json.put("vec", array);
        }
    }
}

