/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@DataObject
public class Service {
    private static final String NODE = "Node";
    private static final String ADDRESS = "Address";
    private static final String SERVICE_ID = "ServiceID";
    private static final String SERVICE_NAME = "ServiceName";
    private static final String SERVICE_TAGS = "ServiceTags";
    private static final String SERVICE_ADDRESS = "ServiceAddress";
    private static final String SERVICE_PORT = "ServicePort";
    private String node;
    private String nodeAddress;
    private String id;
    private String name;
    private List<String> tags;
    private String address;
    private int port;

    public Service() {
    }

    public Service(Service other) {
        this.node = other.node;
        this.nodeAddress = other.nodeAddress;
        this.id = other.id;
        this.name = other.name;
        this.tags = other.tags;
        this.address = other.address;
        this.port = other.port;
    }

    public Service(JsonObject service) {
        this.node = service.getString(NODE);
        this.nodeAddress = service.getString(ADDRESS);
        this.id = service.getString(SERVICE_ID);
        this.name = service.getString(SERVICE_NAME);
        JsonArray tagsArr = service.getJsonArray(SERVICE_TAGS);
        this.tags = tagsArr == null ? null : tagsArr.stream().map(obj -> (String)obj).collect(Collectors.toList());
        this.address = service.getString(SERVICE_ADDRESS);
        this.port = service.getInteger(SERVICE_PORT, Integer.valueOf(0));
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.node != null) {
            jsonObject.put(NODE, this.node);
        }
        if (this.nodeAddress != null) {
            jsonObject.put(ADDRESS, this.nodeAddress);
        }
        if (this.id != null) {
            jsonObject.put(SERVICE_ID, this.id);
        }
        if (this.name != null) {
            jsonObject.put(SERVICE_NAME, this.name);
        }
        if (this.tags != null) {
            jsonObject.put(SERVICE_TAGS, new JsonArray(this.tags));
        }
        if (this.address != null) {
            jsonObject.put(SERVICE_ADDRESS, this.address);
        }
        if (this.port != 0) {
            jsonObject.put(SERVICE_PORT, Integer.valueOf(this.port));
        }
        return jsonObject;
    }

    public String getNode() {
        return this.node;
    }

    public Service setNode(String node) {
        this.node = node;
        return this;
    }

    public String getNodeAddress() {
        return this.nodeAddress;
    }

    public Service setNodeAddress(String nodeAddress) {
        this.nodeAddress = nodeAddress;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Service setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Service setName(String name) {
        this.name = name;
        return this;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Service setTags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public Service setAddress(String address) {
        this.address = address;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Service setPort(int port) {
        this.port = port;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Service service = (Service)o;
        if (this.port != service.port) {
            return false;
        }
        if (this.node != null ? !this.node.equals(service.node) : service.node != null) {
            return false;
        }
        if (this.nodeAddress != null ? !this.nodeAddress.equals(service.nodeAddress) : service.nodeAddress != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(service.id) : service.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(service.name) : service.name != null) {
            return false;
        }
        if (this.tags != null ? !this.sortedTags().equals(service.sortedTags()) : service.tags != null) {
            return false;
        }
        return this.address != null ? this.address.equals(service.address) : service.address == null;
    }

    public int hashCode() {
        int result = this.node != null ? this.node.hashCode() : 0;
        result = 31 * result + (this.nodeAddress != null ? this.nodeAddress.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.sortedTags().hashCode() : 0);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + this.port;
        return result;
    }

    private List<String> sortedTags() {
        ArrayList<String> sorted = null;
        if (this.tags != null) {
            sorted = new ArrayList<String>(this.tags);
            sorted.sort(String::compareTo);
        }
        return sorted;
    }
}

