/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.Node;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntry;
import java.util.ArrayList;

public class ServiceEntryConverter {
    public static void fromJson(JsonObject json, ServiceEntry obj) {
        if (json.getValue("checks") instanceof JsonArray) {
            ArrayList<Check> list = new ArrayList<Check>();
            json.getJsonArray("checks").forEach(item -> {
                if (item instanceof JsonObject) {
                    list.add(new Check((JsonObject)item));
                }
            });
            obj.setChecks(list);
        }
        if (json.getValue("node") instanceof JsonObject) {
            obj.setNode(new Node((JsonObject)json.getValue("node")));
        }
        if (json.getValue("service") instanceof JsonObject) {
            obj.setService(new Service((JsonObject)json.getValue("service")));
        }
    }

    public static void toJson(ServiceEntry obj, JsonObject json) {
        if (obj.getChecks() != null) {
            JsonArray array = new JsonArray();
            obj.getChecks().forEach(item -> array.add(item.toJson()));
            json.put("checks", array);
        }
        if (obj.getNode() != null) {
            json.put("node", obj.getNode().toJson());
        }
        if (obj.getService() != null) {
            json.put("service", obj.getService().toJson());
        }
    }
}

