/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.impl;

import io.vertx.core.json.JsonArray;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

public class Utils {
    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String encode64(String src) {
        if (src == null || src.isEmpty()) {
            return "";
        }
        return new String(Base64.getEncoder().encode(src.getBytes()));
    }

    public static String decode64(String src) {
        if (src == null || src.isEmpty()) {
            return "";
        }
        return new String(Base64.getDecoder().decode(src));
    }

    public static <T> List<T> listOf(List<T> list) {
        if (list == null) {
            return null;
        }
        return new ArrayList<T>(list);
    }

    public static <T> List<T> listOf(JsonArray arr) {
        if (arr == null) {
            return null;
        }
        return arr.getList();
    }
}

