/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.TxnKVOperation;
import io.vertx.ext.consul.TxnKVVerb;
import io.vertx.ext.consul.TxnOperation;
import io.vertx.ext.consul.impl.Utils;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class TxnRequest {
    private List<TxnOperation> operations = new ArrayList<TxnOperation>();

    public TxnRequest() {
    }

    public TxnRequest(JsonObject json) {
        if (json.containsKey("operations")) {
            json.getJsonArray("operations").forEach(entry -> {
                JsonObject obj = (JsonObject)entry;
                if (obj.containsKey("KV")) {
                    JsonObject txn = obj.getJsonObject("KV");
                    this.operations.add(new TxnKVOperation().setKey(txn.getString("Key")).setValue(Utils.decode64(txn.getString("Value"))).setFlags(txn.getLong("Flags")).setIndex(txn.getLong("Index")).setSession(txn.getString("Session")).setType(TxnKVVerb.ofVerb(txn.getString("Verb"))));
                }
            });
        }
    }

    public JsonObject toJson() {
        JsonArray arr = new JsonArray();
        this.operations.forEach(op -> {
            if (op instanceof TxnKVOperation) {
                TxnKVOperation kvOp = (TxnKVOperation)op;
                JsonObject obj = new JsonObject().put("Verb", kvOp.getType().getVerb()).put("Key", kvOp.getKey()).put("Value", Utils.encode64(kvOp.getValue())).put("Flags", Long.valueOf(kvOp.getFlags())).put("Index", Long.valueOf(kvOp.getIndex())).put("Session", kvOp.getSession());
                arr.add(new JsonObject().put("KV", obj));
            }
        });
        return new JsonObject().put("operations", arr);
    }

    public List<TxnOperation> getOperations() {
        return this.operations;
    }

    public int getOperationsSize() {
        return this.operations.size();
    }

    public TxnOperation getOperations(int index) {
        return this.operations.get(index);
    }

    public TxnRequest addOperation(TxnOperation operation) {
        this.operations.add(operation);
        return this;
    }
}

