/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.TxnError;
import io.vertx.ext.consul.TxnResult;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class TxnResponse {
    private final List<TxnResult> results = new ArrayList<TxnResult>();
    private final List<TxnError> errors = new ArrayList<TxnError>();

    public TxnResponse() {
    }

    public TxnResponse(JsonObject json) {
        if (json.getValue("Results") instanceof JsonArray) {
            json.getJsonArray("Results").forEach(entry -> {
                JsonObject obj = (JsonObject)entry;
                if (obj.containsKey("KV")) {
                    this.results.add(new KeyValue(obj.getJsonObject("KV")));
                }
            });
        }
        if (json.getValue("Errors") instanceof JsonArray) {
            json.getJsonArray("Errors").forEach(entry -> this.errors.add(new TxnError((JsonObject)entry)));
        }
    }

    public JsonObject toJson() {
        JsonArray jsonResults = new JsonArray();
        this.results.forEach(op -> {
            if (op instanceof KeyValue) {
                jsonResults.add(new JsonObject().put("KV", ((KeyValue)op).toJson()));
            }
        });
        JsonArray jsonErrors = new JsonArray();
        this.errors.forEach(err -> jsonErrors.add(err.toJson()));
        return new JsonObject().put("Results", jsonResults).put("Errors", jsonErrors);
    }

    public List<TxnResult> getResults() {
        return this.results;
    }

    public int getResultsSize() {
        return this.results.size();
    }

    public TxnResult getResult(int index) {
        return this.results.get(index);
    }

    public TxnResponse addResult(TxnResult result) {
        this.results.add(result);
        return this;
    }

    public List<TxnError> getErrors() {
        return this.errors;
    }

    public int getErrorsSize() {
        return this.errors.size();
    }

    public TxnError getError(int index) {
        return this.errors.get(index);
    }

    public TxnResponse addError(TxnError error) {
        this.errors.add(error);
        return this;
    }
}

