/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.ServiceEntry;
import io.vertx.ext.consul.ServiceEntryListConverter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class ServiceEntryList {
    private long index;
    private List<ServiceEntry> list;

    public ServiceEntryList() {
    }

    public ServiceEntryList(JsonObject json) {
        ServiceEntryListConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public ServiceEntryList(ServiceEntryList other) {
        this.index = other.index;
        this.list = other.list;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        ServiceEntryListConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public long getIndex() {
        return this.index;
    }

    public ServiceEntryList setIndex(long index) {
        this.index = index;
        return this;
    }

    public List<ServiceEntry> getList() {
        return this.list;
    }

    public ServiceEntryList setList(List<ServiceEntry> list) {
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceEntryList that = (ServiceEntryList)o;
        if (this.index != that.index) {
            return false;
        }
        return this.list != null ? this.sorted().equals(that.sorted()) : that.list == null;
    }

    public int hashCode() {
        int result = (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (this.list != null ? this.sorted().hashCode() : 0);
        return result;
    }

    private List<ServiceEntry> sorted() {
        ArrayList<ServiceEntry> sorted = null;
        if (this.list != null) {
            sorted = new ArrayList<ServiceEntry>(this.list);
            sorted.sort(Comparator.comparing(e -> e.getService().getId()));
        }
        return sorted;
    }
}

