/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceListConverter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class ServiceList {
    private long index;
    private List<Service> list;

    public ServiceList() {
    }

    public ServiceList(ServiceList other) {
        this.index = other.index;
        this.list = other.list;
    }

    public ServiceList(JsonObject json) {
        ServiceListConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        ServiceListConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public long getIndex() {
        return this.index;
    }

    public ServiceList setIndex(long index) {
        this.index = index;
        return this;
    }

    public List<Service> getList() {
        return this.list;
    }

    public ServiceList setList(List<Service> list) {
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceList that = (ServiceList)o;
        if (this.index != that.index) {
            return false;
        }
        return this.list != null ? this.sorted().equals(that.sorted()) : that.list == null;
    }

    public int hashCode() {
        int result = (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (this.list != null ? this.sorted().hashCode() : 0);
        return result;
    }

    private List<Service> sorted() {
        ArrayList<Service> sorted = null;
        if (this.list != null) {
            sorted = new ArrayList<Service>(this.list);
            sorted.sort(Comparator.comparing(Service::getId));
        }
        return sorted;
    }
}

