/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.SessionListConverter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

@DataObject
@JsonGen(publicConverter=false)
public class SessionList {
    private long index;
    private List<Session> list;

    public SessionList() {
    }

    public SessionList(SessionList other) {
        this.index = other.index;
        this.list = other.list;
    }

    public SessionList(JsonObject json) {
        SessionListConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        SessionListConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public long getIndex() {
        return this.index;
    }

    public SessionList setIndex(long index) {
        this.index = index;
        return this;
    }

    public List<Session> getList() {
        return this.list;
    }

    public SessionList setList(List<Session> list) {
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionList that = (SessionList)o;
        if (this.index != that.index) {
            return false;
        }
        return this.list != null ? this.sorted().equals(that.sorted()) : that.list == null;
    }

    public int hashCode() {
        int result = (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (this.list != null ? this.sorted().hashCode() : 0);
        return result;
    }

    private List<Session> sorted() {
        ArrayList<Session> sorted = null;
        if (this.list != null) {
            sorted = new ArrayList<Session>(this.list);
            sorted.sort(Comparator.comparing(Session::getId));
        }
        return sorted;
    }
}

