/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.sockjs.impl;

import java.util.Map;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.impl.WebSocketMatcher;
import org.vertx.java.core.impl.VertxInternal;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.core.sockjs.impl.BaseTransport;
import org.vertx.java.core.sockjs.impl.Session;
import org.vertx.java.core.sockjs.impl.TransportListener;

class WebSocketTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(WebSocketTransport.class);

    WebSocketTransport(final VertxInternal vertx, WebSocketMatcher wsMatcher, RouteMatcher rm, String basePath, final Map<String, Session> sessions, final JsonObject config, final Handler<SockJSSocket> sockHandler) {
        super(vertx, sessions, config);
        String wsRE = basePath + "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/" + "websocket";
        wsMatcher.addRegEx(wsRE, new Handler<WebSocketMatcher.Match>(){

            @Override
            public void handle(WebSocketMatcher.Match match) {
                if (log.isTraceEnabled()) {
                    log.trace("WS, handler");
                }
                Session session = new Session(vertx, sessions, config.getLong("heartbeat_period"), sockHandler);
                session.register(new WebSocketListener(match.ws, session));
            }
        });
        rm.getWithRegEx(wsRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest request) {
                if (log.isTraceEnabled()) {
                    log.trace("WS, get: " + request.uri());
                }
                request.response().setStatusCode(400);
                request.response().end("Can \"Upgrade\" only to \"WebSocket\".");
            }
        });
        rm.allWithRegEx(wsRE, new Handler<HttpServerRequest>(){

            @Override
            public void handle(HttpServerRequest request) {
                if (log.isTraceEnabled()) {
                    log.trace("WS, all: " + request.uri());
                }
                request.response().headers().set("Allow", "GET");
                request.response().setStatusCode(405);
                request.response().end();
            }
        });
    }

    private static class WebSocketListener
    implements TransportListener {
        final ServerWebSocket ws;
        final Session session;
        boolean closed;

        WebSocketListener(ServerWebSocket ws, final Session session) {
            this.ws = ws;
            this.session = session;
            ws.dataHandler(new Handler<Buffer>(){

                @Override
                public void handle(Buffer data) {
                    String msgs;
                    if (!session.isClosed() && !(msgs = data.toString()).equals("")) {
                        if (msgs.startsWith("[\"") && msgs.endsWith("\"]") || msgs.startsWith("\"") && msgs.endsWith("\"")) {
                            session.handleMessages(msgs);
                        } else {
                            WebSocketListener.this.close();
                        }
                    }
                }
            });
            ws.closeHandler(new VoidHandler(){

                @Override
                public void handle() {
                    WebSocketListener.this.closed = true;
                    session.shutdown();
                }
            });
        }

        @Override
        public void sendFrame(String body) {
            if (log.isTraceEnabled()) {
                log.trace("WS, sending frame");
            }
            if (!this.closed) {
                this.ws.writeTextFrame(body);
            }
        }

        @Override
        public void close() {
            if (!this.closed) {
                this.ws.close();
                this.session.shutdown();
                this.closed = true;
            }
        }

        @Override
        public void sessionClosed() {
            this.session.writeClosed(this);
            this.closed = true;
            this.ws.close();
        }
    }
}

